//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "dtcp.h"
#include "fkaviar.h"
#include "flogin.h"
#include <stdio.h>
#include <vcl/registry.hpp>

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TRegIniFile*    Reg;           // Registry Objekt
TfrmKaviar*     frmKaviar;     // Zeiger auf Hauptfenster
DTcpClient      tcp;           // Objekt fr Netzwerkverbindung
DFieldDesc      dfDesc;        // Beschreibung fr df Datenausgabe
DFieldDesc      whoDesc;
DFieldDesc      psDesc;
TStringList*    LoginParam;    // Liste der Login Parameter
//---------------------------------------------------------------------------
__fastcall TfrmKaviar::TfrmKaviar(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::FormCreate(TObject *Sender)
{
    AppState = IDLE;
    CurrentCmd = CMD;
    // letzte Fensterposition aus Registry holen. Form->Position muss dafr auf
    // poDesign stehen.
    Reg = new TRegIniFile ("Caviar");
    int l = Reg->ReadInteger("View", "Left", 0);
    int t = Reg->ReadInteger("View", "Top", 0);
    int h = Reg->ReadInteger("View", "Height", 0);
    int w = Reg->ReadInteger("View", "Width", 0);
    if (w && h) {
		Left = (l < Screen->Width) ? l : Left;  // nicht ber aktuelle Gre
		Top = (t < Screen->Height) ? t : Top;
        Width = w;
        Height = h;
    }
    // Login Parameter aus registry
    LoginParam = new TStringList;
    LoginParam->CommaText = Reg->ReadString("Setup", "Login", "");
    for (int i=LoginParam->Count; i<4; i++)
        LoginParam->Add("");
    if (LoginParam->Strings[0] != "")
        Connect ();

    UpdateDiskSheet();
}

//---------------------------------------------------------------------------
void TfrmKaviar::Connect()
{
    tcp.AsyncConnect (LoginParam->Strings[0].c_str(), "512", Handle);
}

//---------------------------------------------------------------------------
void __fastcall TfrmKaviar::FormCloseQuery(TObject *Sender, bool &CanClose)
{
    CanClose = true;
    if (tcp.TcpState != TCP_IDLE) {
        int x = Application->MessageBox (
                "Soll die bestehende Verbindung beendet werden ?",
                "Programmende",
                MB_YESNO|MB_ICONQUESTION);
        if (x == IDNO)
            CanClose = false;
        else {
            tcp.Write ("END\n", 5);
            tcp.Disconnect();
        }
    }
}

//---------------------------------------------------------------------------
void __fastcall TfrmKaviar::FormDestroy(TObject *Sender)
{
    Reg->WriteInteger("View", "Left", Left);
    Reg->WriteInteger("View", "Top", Top);
    Reg->WriteInteger("View", "Height", Height);
    Reg->WriteInteger("View", "Width", Width);
    Reg->WriteString("Setup", "Login", LoginParam->CommaText);
    delete (Reg);
    delete (LoginParam);
}

//---------------------------------------------------------------------------
void __fastcall TfrmKaviar::FormResize(TObject *Sender)
{
    int h = DiskSheet->Height;
    int w = DiskSheet->Width;
    chart->Width = w;
    diskgrid->Width = w;
    chart->Height = h * 2 / 3;
    diskgrid->Top = chart->Height;
    diskgrid->Height = h - diskgrid->Top;
}


//---------------------------------------------------------------------------
void  TfrmKaviar::UpdateDiskSheet ()
{
    chart->Repaint = false;
    int cnt = 0;
    for (int i=0; i<diskgrid->RowCount - 1; i++) {
        int avail = diskgrid->Cells[3][i+1].ToIntDef (0);
        // logische Filesysteme werden nicht angezeigt
        if (avail > 0)
            cnt++;
    }
    if (cnt <= 0) {
        chart->Visible = false;
        return;
    }
    chart->Visible = true;
    chart->RowCount = cnt;
    for (int i=0, cnt = 1; i<diskgrid->RowCount - 1; i++) {
        chart->Row = cnt;
        chart->Column = 1;
        int use = diskgrid->Cells[2][i+1].ToIntDef (0);
        int avail = diskgrid->Cells[3][i+1].ToIntDef (0);
        if (avail <= 0)
            continue;
        chart->RowLabel = diskgrid->Cells[0][i+1];
        chart->Data = (Variant)use/1000;
        chart->Column = 2;
        chart->Data = (Variant)avail/1000;
        cnt++;
    }
    chart->Repaint = true;
}

//---------------------------------------------------------------------------

void  __fastcall  TfrmKaviar::OnTcpEvent (TMessage& Msg)
{
    LPSTR p = (LPSTR)Msg.WParam;
    if (p && p[0]<' ' && p[0]>0)
        p++;
    switch (tcp.TcpState) {
    case TCP_IDLE:
        tcp.Disconnect();
        AppState = IDLE;
        sb->Panels->Items[0]->Text = "offline";
        menConnect->Enabled = true;
        menDisconnect->Enabled = false;

        break;
    case TCP_CONNECTING:
        sb->Panels->Items[0]->Text = "Verbindungsaufbau";
        break;
    case TCP_CONNECTED:
        menConnect->Enabled = false;
        menDisconnect->Enabled = true;
        sb->Panels->Items[0]->Text = "verbunden";
        switch (AppState) {
        case IDLE:
        {
            char buf[512];
            int len;
            sprintf (buf,"0@%s@%s@%s@\n",
                LoginParam->Strings[1].c_str(), // user
                LoginParam->Strings[2].c_str(), // password
                LoginParam->Strings[3].c_str()  // command
            );
            len = strlen(buf);
            for (char *p=buf; *p; p++)
                if (*p == '@')
                    *p = 0;
            tcp.Write (buf, len);
        }
        }
        break;
    case TCP_DISCONNECTING:
        sb->Panels->Items[0]->Text = "trennen";
        sb->Panels->Items[1]->Text = "";
        break;
    }
}

//---------------------------------------------------------------------------
void TfrmKaviar :: SetAppState (enum EAPPSTATE s)
{
    AppState = s;
    switch (s) {
    case IDLE:
        sb->Panels->Items[0]->Text = "offline";
        break;
    case BUSY:
        sb->Panels->Items[0]->Text = "aktiv";
        break;
    case READY:
        sb->Panels->Items[0]->Text = "online";
        break;
    }
}

//---------------------------------------------------------------------------
void  __fastcall  TfrmKaviar::OnTcpMsg (TMessage& Msg)
{
    LPSTR p = (LPSTR)Msg.WParam;
    Application->MessageBox (p, "TCP-IP Meldung", MB_YESNO|MB_ICONQUESTION);
}

//---------------------------------------------------------------------------
void  __fastcall  TfrmKaviar::OnTcpData (TMessage& Msg)
{
    char *Fields[MAXFIELDS];
    int nfields;
    LPSTR p = (LPSTR)Msg.WParam;

    if (p == NULL)  // EOF
        return;
    // die Zeichen %.@ zeigen das Ende eines Dataset an. Da dies fr alle
    // Kommandos gltig ist, wird dieser Test hier ausgefhrt.
    if (p[0] == '%' && p[1] == '.' && p[2] == '@') {
        int x;
        if (CurrentCmd == DISKFREE) {
            x = dfDesc.currentline - dfDesc.headerlines + 1;
            diskgrid->RowCount = x>1?x:2;
            UpdateDiskSheet ();
        }
        if (CurrentCmd == WHO) {
            x = whoDesc.currentline - whoDesc.headerlines + 1;
            grdwho->RowCount = x>1?x:2;
        }
        if (CurrentCmd == PS) {
            x = psDesc.currentline - psDesc.headerlines + 1;
            grdps->RowCount = x>1?x:2;
        }
        SetAppState (READY);
        CurrentCmd = CMD;
        return;
    }

    // Wenn vom Server der Satz S|Systemname empfangen wird, ist dies der
    // Trigger fr den erfolgreichen Login. Alle anderen Meldungen kommen
    // aus dem Login Vorgang und werden als Fehlermeldung angezeigt.
    if (AppState == IDLE) {
        if (p[0] == 'S' && p[1] == '|') {
            SetAppState (READY);
            Sleep (100);   // Unisys V.4 problem workaround
        } else {
            if (strlen(p))
                Application->MessageBox (p, "Unix Meldung", MB_ICONSTOP|MB_OK);
            return;
        }
    }

    switch (CurrentCmd) {
    case CMD:
        nfields = SplitField (p, Fields, MAXFIELDS, '|');
        if (nfields > 0)
            ServerCommand (Fields, nfields);
        break;
    case DISKFREE:
        CopyLine2Grid (p, &dfDesc, diskgrid);
        break;
    case WHO:
        CopyLine2Grid (p, &whoDesc, grdwho);
        break;
    case PS:
        CopyLine2Grid (p, &psDesc, grdps);
        break;
    }
}

//---------------------------------------------------------------------------
void TfrmKaviar :: CopyLine2Grid (char *p, DFieldDesc* desc, TStringGrid *grid)
{
    if (++desc->currentline <= desc->headerlines)
        return;
    String s;

    if (grid->RowCount < desc->currentline-desc->headerlines+1)
        grid->RowCount = desc->currentline + 2;

    for (int i=0; i<desc->Fields->Count; i++) {
        s = "";
        DField* pf = (DField *)desc->Fields->Objects[i];
        if (pf->start >= 0) {
            int st = pf->start;
            int len = pf->length ? pf->length : 99999;
            for (int x=0; x<len && p[st+x]; x++)
                s += p[st+x];
            grid->Cells[i][desc->currentline-desc->headerlines] = s;
        } else {
            char *buf = p;
            for (int ix=0; *buf; ix++) {
                for (; *buf && *buf<=' '; *buf++);  // skip whitespace
                for (; *buf && (*buf>' '||*buf<0); buf++)
                    if (ix == pf->index)
                        s += *buf;
                if (ix == pf->index)
                   break;
            }
            grid->Cells[i][desc->currentline-desc->headerlines] = s;
        }
    }
}

//---------------------------------------------------------------------------
int TfrmKaviar :: SplitField (char *p, char **Fields, int maxfld, int ifs)
{
    int n = 0;
    if (*p && maxfld)
        Fields[n++] = p;
    for (; *p && n<maxfld; p++)
        if (*p == ifs) {
            *p++ = 0;
            Fields[n++] = p;
        }
    return n;
}

//---------------------------------------------------------------------------
void TfrmKaviar::ServerCommand (char **Fields, int nfields)
{
    String cmd = Fields[0];

    if (cmd == "S") {
        if (nfields > 1) {
            Caption = Fields[1];
            sb->Panels->Items[1]->Text = Fields[1];
            PageCtrl->ActivePage = DiskSheet;
            menUpdateClick(NULL);
        }
        return;
    }

    if (cmd == "MSG") {
        if (nfields > 1)
            Application->MessageBox (Fields[1], "Servermeldung", MB_OK|MB_ICONSTOP);
        return;
    }

    // disk free format description from server
    if (cmd == "DF") {
        PrepareGrid (&dfDesc, Fields, nfields, diskgrid);
        CurrentCmd = DISKFREE;
        SetAppState (BUSY);
        return;
    }
    // w format description from server
    if (cmd == "W") {
        PrepareGrid (&whoDesc, Fields, nfields, grdwho);
        CurrentCmd = WHO;
        SetAppState (BUSY);
        return;
    }
    // ps format description from server
    if (cmd == "PS") {
        PrepareGrid (&psDesc, Fields, nfields, grdps);
        CurrentCmd = PS;
        SetAppState (BUSY);
        return;
    }

}
//---------------------------------------------------------------------------
void TfrmKaviar::PrepareGrid (DFieldDesc* pd, char **Fields, int nfields, TStringGrid* grid)
{
    pd->Clear();
    if (nfields < 4)
        return;
    pd->option = Fields[1];
    pd->headerlines = atoi(Fields[2]);
    for (int i=3; i<nfields; i++) {
        DField* pf;

        char *subfld[4];
        int n = SplitField (Fields[i], subfld, 4, ';');
        if (i-2 >= grid->ColCount)
            grid->ColCount = i-2;
        if (n >= 3) {
            grid->Cells[i-3][0] = subfld[0];
            pf = new DField;
            pd->Fields->AddObject (subfld[0], pf);
            pf->type = subfld[1][0];
            pf->index = -1;
            pf->start = -1;
            pf->length = -1;
        }
        if (n == 3) {
            // Eintrag besteht aus Name, Typ und Index
            pf->index = atoi(subfld[2]);
        }
        if (n == 4) {
            // Eintrag besteht aus Name, Typ, Start und Lnge
            pf->start = atoi(subfld[2]);
            pf->length = atoi(subfld[3]);
        }
    }
    grid->ColCount = nfields-3;
}

//---------------------------------------------------------------------------
void __fastcall TfrmKaviar::menConnectClick(TObject *Sender)
{
    if (LoginParam->Strings[0] != "")
        Connect ();
    else {
        if (frmlogin->Execute (LoginParam) == true)
            Connect();
    }
}

//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::PageCtrlChange(TObject *Sender)
{
    if (AppState == READY)
        menUpdateClick(Sender);
    Resize();
}

//---------------------------------------------------------------------------


void __fastcall TfrmKaviar::menSetupClick(TObject *Sender)
{
    frmlogin->Execute (LoginParam);
}
//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::menUpdateClick(TObject *Sender)
{
    if (PageCtrl->ActivePage == DiskSheet) {
        tcp.Write ("DF\n", 3);
        SetAppState (BUSY);
    }
    if (PageCtrl->ActivePage == WhoSheet) {
        tcp.Write ("W\n", 2);
        SetAppState (BUSY);
    }
    if (PageCtrl->ActivePage == PsSheet) {
        tcp.Write ("PS\n", 3);
        SetAppState (BUSY);
    }
}
//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::menDisconnectClick(TObject *Sender)
{
    tcp.Write ("END\n", 4);
    SetAppState (BUSY);
}

//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::grdpsMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button == mbRight)
        popps->Popup(Left + X + 20, Top + Y + 20);
}
//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::SIGKILL1Click(TObject *Sender)
{
    int s = ((TControl *)Sender)->Tag;
    for (int r=grdps->Selection.Top; r<=grdps->Selection.Bottom; r++) {
        String k = Format("Wollen Sie Proze-ID %s wirklich mit Signal %d beenden?\n",
            OPENARRAY(TVarRec, (grdps->Cells[1][r].c_str(), s)));
        int e = Application->MessageBox (k.c_str(),
            "Kritische Aktion",
            MB_YESNO|MB_ICONEXCLAMATION);
        if (e == IDYES) {
            k = Format("K|%d|%s\n", OPENARRAY(TVarRec, (s,grdps->Cells[1][r].c_str())));
            tcp.Write (k.c_str(), k.Length());
        }
    }
}
//---------------------------------------------------------------------------

void __fastcall TfrmKaviar::menQuitClick(TObject *Sender)
{
    Close();
}

//---------------------------------------------------------------------------

