//---------------------------------------------------------------------------
#ifndef dtcpH
#define dtcpH

#include <winsock.h>
//---------------------------------------------------------------------------
#define WM_TCPEVENT     WM_USER+234
#define WM_TCPMSG       WM_USER+235
#define WM_TCPDATA      WM_USER+236

class DTcpClient
{
public:         // Interface Methods
					    DTcpClient ();
                        ~DTcpClient ();
	bool			    AsyncConnect (LPSTR host, LPSTR service, HWND hWnd);
	bool			    Disconnect ();
    bool                Write (LPSTR buf, int len);

public:         // Interface Members
#define TCP_IDLE            0
#define TCP_CONNECTING      1
#define TCP_CONNECTED       2
#define TCP_DISCONNECTING   3
    int                 TcpState;

public:         // Interface Callbacks
    virtual void        OnTcpEvent ();
    virtual void        OnTcpMsg (LPSTR msg);
    virtual void        OnTcpData (LPSTR pbuf);

protected:      // Members
    String              Host;
    String              Port;
	SOCKET				Socket;
	HANDLE			    hThread;
    HWND                hNotify;
#define RCVBUFSZ    2048
    char                buf[RCVBUFSZ];

protected:      // Methods
    String&             WSErrtext ();
    bool                TcpConnect ();
    void                Msg (LPSTR fmt, ...);
    void                SetState (int newstate);

public:
    void                WorkerThread ();
};

void _WorkerThread (void *arg);


#endif



