#include <vcl.h>
#pragma hdrstop

#include <process.h>
#include "dtcp.h"

extern int errno;

static WSADATA 	wsaData;
static int      WSARefCount = 0;

//---------------------------------------------------------------------------
DTcpClient :: DTcpClient()
{
    if (WSARefCount == 0)
		if (WSAStartup(MAKEWORD(1,1), &wsaData)) {
            String s = "WSAStartup:";
            s += WSErrtext();
            throw Exception (s);
        }
	if (LOBYTE(wsaData.wVersion) < 1 || HIBYTE(wsaData.wVersion) < 1) {
        if (WSARefCount == 0)
    		WSACleanup();
        throw Exception ("WSAStartup: ungltige Windows Socket Version");
	}
    Socket = 0;
    hThread = NULL;
    TcpState = TCP_IDLE;
	WSARefCount++;
}

//---------------------------------------------------------------------------
DTcpClient :: ~DTcpClient ()
{
    if (Socket)
        Disconnect ();
    if (--WSARefCount == 0)
        WSACleanup();
}

//---------------------------------------------------------------------------
bool DTcpClient :: AsyncConnect (LPSTR host, LPSTR service, HWND hWnd)
{
    if (TcpState != TCP_IDLE)
        return false;
    hNotify = hWnd;
    Host = host;
    Port = service;
    int thrid;

    thrid = _beginthread(_WorkerThread,4096,(void *)this);
    if (thrid == (unsigned long)-1) {
        Msg ("_beginthread: %E");
        return false;
    }

    return true;
}

//---------------------------------------------------------------------------
bool DTcpClient :: Disconnect ()
{
    TcpState = TCP_IDLE;
    if (!Socket)
        return false;
  	closesocket (Socket);
	Socket = 0;
    return true;
}


//---------------------------------------------------------------------------
// Wenn eine C++ Memberfunktion als eigener thread laufen soll, kann man entweder
// das Borland proprietre Schlsselwort "closure" verwenden, oder den kleinen
// Umweg ber eine Standard C Funktion nehmen.

void _WorkerThread (void *arg)
{
	((DTcpClient*)arg)->WorkerThread ();
}

//---------------------------------------------------------------------------
// Dieser Thread ist fr Connect, Lesen und Disconnect zustndig. Jeder Status-
// wechsel wird per Windows Botschaft WM_TCPEVENT an das Fenster gesendet, das
// mit SetNotificationWindow () definiert wurde. Durch Senden einer Windowsbotschaft
// ist die Konsistenz der multithreaded environment gewhrleistet.
void  DTcpClient :: WorkerThread ()
{
    int offset = 0;
    SetState (TCP_CONNECTING);
    if (TcpConnect () == false)
        goto THREADEX;
    SetState (TCP_CONNECTED);

    for (;;) {
        int n = recv (Socket, &buf[offset], RCVBUFSZ-1-offset, 0);
        if (Socket == 0) // destruktor was called
            return;
        if (n == 0) {
            OnTcpData (NULL);
            goto THREADEX;
        }
        if (n < 0) {
            Msg ("recv(): %W");
            goto THREADEX;
        }
        n += offset;
        offset = 0;
        char *p1 = buf;
        char *p2 = buf;
        for (; p2 < &buf[n]; p2++)
            if (*p2 == 0x0a || *p2 == 0x00) {
                *p2 = 0;
                OnTcpData (p1);
                p1 = &p2[1];
            }
        n = p2 - p1;
        if (n > 0) {
            for (int i=0; i < n; i++)
                buf[i] = p1[i];
            offset = n;
        }
    }
THREADEX:
    if (Socket) {
        SetState (TCP_DISCONNECTING);
        closesocket (Socket);
    }
    Socket = 0;
    hThread = 0;
    SetState (TCP_IDLE);
    return;
}

//---------------------------------------------------------------------------
void DTcpClient :: SetState (int newstate)
{
    TcpState = newstate;
    OnTcpEvent ();
}

//---------------------------------------------------------------------------
// abgeleitete Klassen knnen diese virtuellen Funktionen berschreiben und
// damit eine andere Signalisierung whlen
void DTcpClient :: OnTcpEvent ()
{
    SendMessage(hNotify, WM_TCPEVENT, NULL, (LPARAM)this);
}

void DTcpClient :: OnTcpMsg (LPSTR p)
{
    SendMessage(hNotify, WM_TCPMSG, (WPARAM)p, (LPARAM)this);
}

//---------------------------------------------------------------------------
void DTcpClient :: OnTcpData (LPSTR pbuf)
{
    SendMessage(hNotify, WM_TCPDATA, (WPARAM)pbuf, (LPARAM)this);
}

//---------------------------------------------------------------------------
bool DTcpClient :: TcpConnect ()
{
    short portnum = (short)Port.ToIntDef (0);
	if (portnum == 0) {
    	struct servent FAR * s_info;
		if ((s_info = getservbyname (Port.c_str(), "tcp")) != NULL)
			portnum = ntohs (s_info->s_port);
	}
    if (portnum == 0) {
        return false;
    }
	Socket = socket (PF_INET, SOCK_STREAM, 0);
	if (Socket == SOCKET_ERROR) {
        Msg ("socket(): %W");
        return false;
	}
	ULONG addr = inet_addr (Host.c_str());
	if (addr == (ULONG)INADDR_NONE) {
        struct hostent* phe = gethostbyname (Host.c_str());
        if (!phe) {
            Msg ("Hostname %s nicht gefunden", Host.c_str());
            return false;
        }
        addr = *(u_long FAR *) phe->h_addr_list[0];
    }

	struct sockaddr_in	cli;
	cli.sin_family = AF_INET;
	cli.sin_addr.s_addr = INADDR_ANY;
	cli.sin_port = 0;

	struct sockaddr_in	srv;
	srv.sin_family = AF_INET;
	srv.sin_addr.s_addr = addr;
	srv.sin_port = htons (portnum);

	// bind client socket to any local interface and port
	if (bind(Socket,(LPSOCKADDR)&cli, sizeof(cli)) == SOCKET_ERROR) {
        Msg ("bind(): %W");
		closesocket (Socket);
		Socket = 0;
        return false;
	}

	if (connect(Socket,(LPSOCKADDR)&srv,sizeof(srv)) == SOCKET_ERROR) {
        Msg ("connect(): %W");
		closesocket (Socket);
		Socket = 0;
        return false;
	}
    return true;
}


//---------------------------------------------------------------------------
bool DTcpClient :: Write (LPSTR buf, int len)
{
	char *p = buf;
	int x;
	do {
		if ((x = send (Socket, p, len, 0)) == SOCKET_ERROR) {
            Msg ("send(): %W");
			return false;
        }
		p += x;
		len -= x;
	} while (len > 0);
	return true;
}

//---------------------------------------------------------------------------
String& DTcpClient :: WSErrtext ()
{
    static String s;
    int e = WSAGetLastError();
    s = e;
    s += ": ";

	switch (e) {
    default: 	s += "unknown WinSock error code";
	case WSAEWOULDBLOCK: s += "operation would block";break;
	case WSANOTINITIALISED:	s += "win socket not initialized";break;
	case WSAENETDOWN: s +="network is down";break;
	case WSAEINPROGRESS: s+="blocking WinSock operation is in progress"; break;
	case WSAEMFILE: s+= "No more file descriptors available"; break;
	case WSAENOBUFS: s+="No buffer space available";break;
	case WSAEPROTONOSUPPORT: s+="specified port not supported";break;
	case WSAEPROTOTYPE: s+="specified port wrong type"; break;
	case WSAESOCKTNOSUPPORT: s+="socket type not supported";break;
	case WSAEADDRINUSE: s+="specified address is already in use"; break;
	case WSAEFAULT: s+= "nSockAddrLen argument too small"; break;
	case WSAEINVAL: s+="socket is already bound to an address"; break;
	case WSAENOTSOCK: s+="descriptor is not a socket"; break;
	case WSAEADDRNOTAVAIL:s+="address not available"; break;
	case WSAEAFNOSUPPORT:s+="addresses in family cannot be used"; break;
	case WSAECONNREFUSED:s+="attempt to connect rejected"; break;
	case WSAEISCONN: s+="socket is already connected"; break;
	case WSAENETUNREACH: s+= "network cannot be reached"; break;
	case WSAETIMEDOUT: s+="attempt to connect timed out"; break;
	case WSAEACCES: s+="requested address is a broadcast address"; break;
	case WSAENETRESET: s+="connection must be reset"; break;
	case WSAENOTCONN: s+="socket is not connected"; break;
	case WSAEOPNOTSUPP: s+="MSG_OOB socket is not SOCK_STREAM"; break;
	case WSAESHUTDOWN: s+="socket has been shut down"; break;
	case WSAEMSGSIZE: s+="SOCK_DGRAM, datagram too large"; break;
	case WSAECONNABORTED: s+="virtual circuit aborted"; break;
	case WSAECONNRESET: s+= "virtual circuit was reset by peer"; break;
	}
    return s;
}

//---------------------------------------------------------------------------
void DTcpClient :: Msg (LPSTR fmt, ...)
{
	va_list		ap;
	LPSTR       p;
	int			i;
	va_start (ap, fmt);
    String s;
	TCHAR buf[FORMAT_MESSAGE_MAX_WIDTH_MASK+1];
    int wsaerr = WSAGetLastError ();
    int winerr = GetLastError  ();

	for (;*fmt;fmt++) {
		if (*fmt != '%')
			s += *fmt;
        else {
            fmt++;
    		switch (*fmt) {
    		case 'd':
                i = va_arg (ap, int);
		    	s += i;
			    break;

    		case 's':
	    		p = va_arg (ap, char  *);
		    	s += p;
			    break;

    		case 'e':
	    		s += winerr;
		    	break;

    		case 'E':
    			if (FormatMessage (
            		FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_MAX_WIDTH_MASK,
                	NULL,
                    winerr,
                    0,
                    buf,
                    FORMAT_MESSAGE_MAX_WIDTH_MASK,
                    NULL))
            	    s += buf;
                else
                    s += wsaerr;
		    	break;

            case 'w':
                s += wsaerr;
                break;

            case 'W':
                s += WSErrtext();
                break;
    		}
        }
	}
	va_end (ap);
    OnTcpMsg (s.c_str());
	return;
}

//---------------------------------------------------------------------------





