﻿<%@ Page Title="Neuer Passagier" Language="C#" MasterPageFile="~/WWWings.master"
 AutoEventWireup="true" CodeFile="NeuerPassagier.aspx.cs" Inherits="NeuerPassagier" %>

<asp:Content ContentPlaceHolderID="C_Ueberschrift" runat="server">
 Neuer Passagier
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="C_Inhalt" runat="Server">
 <!-- #################### Datenquelle ########################### -->
 <asp:ObjectDataSource ID="ODS" runat="server" DataObjectTypeName="WWWings_GO.Passagier"
 TypeName="NeuerPassagierManager"  SelectMethod="Laden" InsertMethod="Einfuegen">
 </asp:ObjectDataSource>
 <!-- #################### DetailsView ########################### -->
 <asp:DetailsView ID="C_Passagier" runat="server" AutoGenerateRows="False" DefaultMode="Insert"
  DataKeyNames="ID" DataSourceID="ODS" Width="300px" OnModeChanging="C_Passagier_ModeChanging">
  <CommandRowStyle CssClass="dunkel" />
  <RowStyle CssClass="hell" />
  <Fields>
   <%-- #################### ID ########################### --%>
   <asp:BoundField DataField="ID" HeaderText="ID" ReadOnly="true" InsertVisible="false" />
   <%-- #################### Vorname ########################### --%>
   <asp:TemplateField HeaderText="Vorname">
    <ItemTemplate>
     <asp:Label ID="C_VornameAusgabe" runat="server" Text='<%# Bind("Vorname") %>'>
     </asp:Label>
    </ItemTemplate>
    <EditItemTemplate>
     <asp:TextBox ID="C_VornameEingabe" runat="server" Text='<%# Bind("Vorname") %>'>
     </asp:TextBox>
     <asp:RequiredFieldValidator ID="RequiredFieldValidator_Vorname" runat="server" ControlToValidate="C_VornameEingabe"
      ErrorMessage="*"></asp:RequiredFieldValidator>
    </EditItemTemplate>
   </asp:TemplateField>
   <%-- #################### Name ########################### --%>
   <asp:TemplateField HeaderText="Name">
    <ItemTemplate>
     <asp:Label ID="C_NameAusgabe" runat="server" Text='<%# Bind("Name") %>'>
     </asp:Label>
    </ItemTemplate>
    <EditItemTemplate>
     <asp:TextBox ID="C_NameEingabe" runat="server" Text='<%# Bind("Name") %>'>
     </asp:TextBox>
     <asp:RequiredFieldValidator ID="RequiredFieldValidator_Name" runat="server" ControlToValidate="C_NameEingabe"
      ErrorMessage="*"></asp:RequiredFieldValidator>
    </EditItemTemplate>
   </asp:TemplateField>
   <%-- #################### Geburtsdatum ########################### --%>
   <asp:TemplateField HeaderText="Geburtsdatum">
    <ItemTemplate>
     <asp:Label ID="C_GeburtsdatumAusgabe" runat="server" Text='<%# Bind("Geburtsdatum") %>'>
     </asp:Label>
    </ItemTemplate>
    <EditItemTemplate>
     <asp:TextBox ID="C_GeburtsdatumEingabe" runat="server" Text='<%# Bind("Geburtsdatum") %>'>
     </asp:TextBox>
     <asp:RegularExpressionValidator ID="RequiredFieldValidator_Geburtsdatum" runat="server"
      ControlToValidate="C_GeburtsdatumEingabe" ValidationExpression="[0-9]{1,2}\.[0-9]{1,2}\.[0-9]{4,4}"
      ErrorMessage="*"></asp:RegularExpressionValidator>
    </EditItemTemplate>
   </asp:TemplateField>
   <%-- #################### Passagier-Status ########################### --%>
   <asp:TemplateField HeaderText="Passagier-Status">
    <ItemTemplate>
     <asp:Label ID="StatusLabel" runat="server" Text='<%# Bind("PassagierStatus") %>'>
     </asp:Label>
    </ItemTemplate>
    <EditItemTemplate>
     <asp:DropDownList ID="StatusAuswahl" runat="server" SelectedValue='<%# Bind("PassagierStatus") %>'>
      <asp:ListItem Value="A"></asp:ListItem>
      <asp:ListItem Value="B"></asp:ListItem>
      <asp:ListItem Value="C"></asp:ListItem>
     </asp:DropDownList>
    </EditItemTemplate>
   </asp:TemplateField>
   <%--- #################### Befehle ########################### --%>
   <asp:CommandField CancelText="Abbrechen" InsertText="Speichern" ShowInsertButton="True" />
  </Fields>
 </asp:DetailsView>
</asp:Content>
