﻿
using System.ComponentModel;
using System.Windows;
using WWWings_GO;
namespace WWWings_WPF
{
 public partial class MainWindowViewModel : INotifyPropertyChanged
 {

  ///  ########################### Befehle ###########################################
  public ActionCommand EndeCommand { get; set; }

  private void Ende()
  {
   Application.Current.MainWindow.Close();
  }


  ///  ########################### Daten ###########################################
  private bool tab1Aktiv;


  /// <summary>
  /// Ist Ribbon Tab 1 ausgewählt?
  /// </summary>
  public bool Tab1Aktiv
  {
   get { return tab1Aktiv; }
   set
   {
    tab1Aktiv = value;

    if (tab1Aktiv)
    {
     this.ActiveAnsichtViewModel = new WWWings_WPF.Ansichten.BuchungViewModel();
    }

    OnPropertyChanged("Tab1Aktiv");
   }
  }

  private bool tab2Aktiv;

  /// <summary>
  /// Ist Ribbon Tab 2 ausgewählt?
  /// </summary>
  public bool Tab2Aktiv
  {
   get { return tab2Aktiv; }
   set
   {
    tab2Aktiv = value;

    if (tab2Aktiv)
    {
     // zunächst ohne die fertig implementierte NeuePassagier-Maske:
     //this.ActiveAnsichtViewModel = new WWWings_WPF.Ansichten.NeuerPassagierViewModel();

     //// Später mit NeuePassagierViewModel, der Event auslöst:
     var pvm = new WWWings_WPF.Ansichten.NeuerPassagierViewModel();
     this.ActiveAnsichtViewModel = pvm;
     pvm.NeuerPassagierViewModelExit += delegate(Passagier passagier)
     {
      Tab1Aktiv = true; // RibbonTab umschalten
      this.ActiveAnsichtViewModel = new WWWings_WPF.Ansichten.BuchungViewModel(passagier); // ViewModel umschalten und Passagier übergeben
     };

    }

    OnPropertyChanged("Tab2Aktiv");
   }
  }


  private INotifyPropertyChanged activeAnsichtViewModel;

  /// <summary>
  /// Welche ist das aktive ViewModel
  /// </summary>
  public INotifyPropertyChanged ActiveAnsichtViewModel
  {
   get { return activeAnsichtViewModel; }
   set { activeAnsichtViewModel = value; OnPropertyChanged("ActiveAnsichtViewModel"); }
  }


  ///  ########################### INotifyPropertyChanged #########################################
  #region INotifyPropertyChanged Members

  public event PropertyChangedEventHandler PropertyChanged;


  protected virtual void OnPropertyChanged(string propertyName)
  {
   if (PropertyChanged != null)
   {
    PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
   }
  }


  ///  ########################### Konstruktur ###########################################
  public MainWindowViewModel()
  {

   EndeCommand = new ActionCommand(Ende);
   // Erste Viewmodel
   this.ActiveAnsichtViewModel = new WWWings_WPF.Ansichten.BuchungViewModel();

  }

  #endregion


 }
}
