﻿using System.ComponentModel;
using System.Collections.ObjectModel;
using WWWings_GO;
using WWWings_Dienstproxies.WWWingsServer;
using System;

namespace WWWings_WPF.Ansichten
{
 public partial class NeuerPassagierViewModel : INotifyPropertyChanged
 {

  ///  ########################### Befehle ###########################################
  public ActionCommand SpeichernCommand { get; set; }
  public ActionCommand AbbrechenCommand { get; set; }

  ///  ########################### Ereignisse ###########################################
  public event Action<Passagier> NeuerPassagierViewModelExit;

  ///  ########################### Daten (Properties) ###########################################
  public Passagier passagier;
  public Passagier Passagier // Das neue Passagier-OBjejt
  {
   get { return passagier; }
   set { passagier = value; OnPropertyChanged("Passagier"); }
  }

  public string fehlerMeldung;
  public string FehlerMeldung // StatusMeldung nach Speichern
  {
   get { return fehlerMeldung; }
   set { fehlerMeldung = value; OnPropertyChanged("FehlerMeldung"); }
  }

  ///  ########################### Konstruktor ###########################################

  public NeuerPassagierViewModel()
  {
   SpeichernCommand = new ActionCommand(Speichern);
   AbbrechenCommand = new ActionCommand(Abbrechen);

   // Passagier instanziieren
   Passagier = new Passagier();

   // Nur zum Test
  Passagier.Vorname = "Max";
  Passagier.Name = "Mustermann";
  Passagier.Geburtsdatum = DateTime.Now.Date;
  Passagier.PassagierStatus = "A";
  }

  ///  ########################### Aktion 1 ###########################################

  private void Speichern()
  {

   try
   {
    // Neuen Passagier speichern
    ObservableCollection<Passagier> GeändertePassagiere = new ObservableCollection<Passagier>() { Passagier };
    string Statistik;

    BuchungsServiceClient client = new BuchungsServiceClient();
    var antwort = client.SavePassagierSet(GeändertePassagiere, out Statistik);
    client.Close();

    if (antwort.Count == 1)
    {
     // Der erste neue Passagier muss der angelegte sein, der nun auch die ID enthält!
     Passagier = antwort[0];
     FehlerMeldung = "";
     if (NeuerPassagierViewModelExit != null) NeuerPassagierViewModelExit(Passagier);
    }
   }
   catch (Exception ex)
   {
    FehlerMeldung = ex.Message;
    if (NeuerPassagierViewModelExit != null) NeuerPassagierViewModelExit(null);
   }


  }

  ///  ########################### Aktion 2 ###########################################


  private void Abbrechen()
  {
   if (NeuerPassagierViewModelExit != null) NeuerPassagierViewModelExit(null)
  }

  ///  ########################### INotifyPropertyChanged ###########################################

  #region INotifyPropertyChanged Members

  public event PropertyChangedEventHandler PropertyChanged;


  protected virtual void OnPropertyChanged(string propertyName)
  {
   if (PropertyChanged != null)
   {
    PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
   }
  }
  #endregion
 }
}
