﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Windows.Media;
using WWWings_Dienstproxies.WWWingsServer;
using WWWings_GO;

namespace WWWings_WPF.Ansichten
{
 public partial class BuchungViewModel : INotifyPropertyChanged
 {
  ///  ########################### Befehle ###########################################
  public ActionCommand FlugSuchenCommand { get; set; }
  public ActionCommand PassagierSuchenCommand { get; set; }
  public ActionCommand BuchenCommand { get; set; }
  
  ///  ########################### Daten (Properties) ###########################################
   ObservableCollection<string> flughaefen;
  public ObservableCollection<string> Flughaefen // Liste der Orte für Abflug- und Zielauswahl
  {
   get { return flughaefen; }
   set { flughaefen = value; OnPropertyChanged("Flughaefen"); }
  }

  private ObservableCollection<Flug> fluege { get; set; }
  public ObservableCollection<Flug> Fluege // gefundene Flüge
  {
   get { return fluege; }
   set { fluege = value; this.OnPropertyChanged("Fluege"); }
  }

  private ObservableCollection<Passagier> passagiere;
  public ObservableCollection<Passagier> Passagiere // gefundene Passagiere
  {
   get { return passagiere; }
   set { passagiere = value; this.OnPropertyChanged("Passagiere"); }
  }

  Flug flug;
  public Flug Flug // Gewählter Flug
  {
   get { return flug; }
   set { flug = value; OnPropertyChanged("Flug");
   BuchenCommand.IsEnabled = (Flug != null && Passagier != null);
   }
  }

  Passagier passagier;
  public Passagier Passagier // gewählter Passagier
  {
   get { return passagier; }
   set { passagier = value; OnPropertyChanged("Passagier");
   BuchenCommand.IsEnabled = (Flug != null && Passagier != null);
   }
  }

  private string flugNummer;
  public string FlugNummer // eingegebene Flugnummer
  {
   get { return flugNummer; }
   set { flugNummer = value; OnPropertyChanged("FlugNummer"); }
  }

  private string abflugort;
  public string Abflugort // ausgewählter Abflugort
  {
   get { return abflugort; }
   set { abflugort = value; OnPropertyChanged("Abflugort"); }
  }

  private string zielort;
  public string Zielort // ausgewählter Zielort
  {
   get { return zielort; }
   set { zielort = value; OnPropertyChanged("Zielort"); }
  }

  private string passagierID;
  public string PassagierID // eingegebene ID
  {
   get { return passagierID; }
   set { passagierID = value; OnPropertyChanged("PassagierID"); }
  }

  private string passagiername;
  public string PassagierName // eingegebener Name
  {
   get { return passagiername; }
   set { passagiername = value; OnPropertyChanged("PassagierName"); }
  }

  private string buchenErgebnis;
  public string BuchenErgebnis // Textausgabe nach Buchung
  {
   get { return buchenErgebnis; }
   set { buchenErgebnis = value; OnPropertyChanged("BuchenErgebnis"); }
  }

  private SolidColorBrush buchenErgebnisFarbe;
  public SolidColorBrush BuchenErgebnisFarbe // Textfarbe der Textausgabe nach Buchung
  {
   get { return buchenErgebnisFarbe; }
   set { buchenErgebnisFarbe = value; OnPropertyChanged("BuchenErgebnisFarbe"); }
  }

  ///  ########################### Konstruktor ###########################################

  public BuchungViewModel(Passagier passagier = null)
  {


   FlugSuchenCommand = new ActionCommand(FlugSuchen);
   PassagierSuchenCommand = new ActionCommand(PassagierSuchen);
   BuchenCommand = new ActionCommand(Buchen);
   BuchenCommand.IsEnabled = false;

   BuchungsServiceClient client = new BuchungsServiceClient();
   Flughaefen = client.GetFlughaefen();
   client.Close();

   if (passagier != null)
   {
    Passagiere = new ObservableCollection<WWWings_GO.Passagier>() { passagier };
    Passagier = passagier;
   }
   // nur zum einfacheren Testen!
   Abflugort = "Berlin";
   PassagierName = "Müller";
  }

  ///  ########################### Aktion 1 ###########################################

  private void FlugSuchen()
  {
   BuchungsServiceClient client = new BuchungsServiceClient();
 
   int FNr;
   if (Int32.TryParse(FlugNummer, out FNr))
   {
    var Flug = client.GetFlug(FNr);
    if (Flug!=null) Fluege = new ObservableCollection<Flug> { Flug };
    else Fluege = new ObservableCollection<Flug> {  };
   }
   else
   {
    Fluege = client.GetFluege(Abflugort, Zielort);
   }

   //if (Fluege != null) Fluege = new ListCollectionView(Fluege);
 
   client.Close();
  }

  ///  ########################### Aktion 2 ###########################################

  private void PassagierSuchen()
  {
   
   BuchungsServiceClient client = new BuchungsServiceClient();
   int PID;
   if (Int32.TryParse(PassagierID, out PID))
   {

    var Passagier = client.GetPassagier(PID);

    if (Passagier != null) Passagiere = new ObservableCollection<Passagier> { Passagier };
    else Passagiere = new ObservableCollection<Passagier>();
   }
   else
   {
    Passagiere = client.GetPassagiere(PassagierName);
   }

   if (Passagiere != null) Passagiere = new ObservableCollection<WWWings_GO.Passagier>(Passagiere.OrderBy(x => x.GanzerName));

   client.Close();
  }

  ///  ########################### Aktion 3 ###########################################

  private void Buchen()
  {
   if (Flug == null || Passagier == null) return;

   BuchungsServiceClient client = new BuchungsServiceClient();

   try
   {
    string ergebnis = client.CreateBuchung(Flug.ID, Passagier.ID);
    if (ergebnis == "OK")
    {
     BuchenErgebnis = "Buchung erfolgreich!";
     BuchenErgebnisFarbe = new SolidColorBrush(Colors.Green);
    }
    else
    {
     BuchenErgebnis = ergebnis;
     BuchenErgebnisFarbe = new SolidColorBrush(Colors.Red);
    }
   }
   catch (Exception ex)
   {
    BuchenErgebnis = "Fehler beim Aufruf der Buchungsfunktion: " + ex.Message;
    BuchenErgebnisFarbe = new SolidColorBrush(Colors.Red);
   }

   client.Close();
  }

  ///  ########################### INotifyPropertyChanged ###########################################

  #region INotifyPropertyChanged Members

  public event PropertyChangedEventHandler PropertyChanged;


  protected virtual void OnPropertyChanged(string propertyName)
  {
   if (PropertyChanged != null)
   {
    PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
   }
  }
  #endregion
 }
}
