﻿using System;
using System.Collections.Generic;
using WWWings_GO;
using WWWings_Dienstproxies.WWWingsServer;
using System.Collections.ObjectModel;

namespace WWWings_TestKonsole
{
 class Program
 {
  static void Main(string[] args)
  {
   Console.Title = "World aus Wide Wings - Tutorial - Testkonsole";
   Console.WriteLine("Start...");

   // Nur einmalig ausführen, um DB zu befüllen!
   // WWWings_GL.Datengenerator.Init_DB();

   FlugBuchenDemo();

   Console.WriteLine("Fertig!");
   Console.ReadLine();
  }


  private static void FlugBuchenDemo()
  {

   BuchungsServiceClient bm = new BuchungsServiceClient();

   // ----------- Flug ermitteln
   int FlugID = 101;

   Flug f = bm.GetFlug(FlugID);


   if (f == null)
   {
    Console.WriteLine("Flug nicht gefunden!");
   }
   else
   {
    Console.WriteLine("Flug: " + f.ToString());
   }

   // ----------- Neuen Passagier anlegen
   Passagier pneu = new Passagier();
   pneu.Vorname = "Max";
   pneu.Name = "Mustermann";
   pneu.PassagierStatus = "C";
   pneu.Geburtsdatum = DateTime.Now.AddYears(-40);

   ObservableCollection<Passagier> GeändertePassagiere = new ObservableCollection<Passagier>() { pneu };
   string Statistik;
   var antwort = bm.SavePassagierSet(GeändertePassagiere, out Statistik);

   Console.WriteLine("Statistik von SavePassagierSet: " + Statistik);

   if (antwort.Count == 0)
   {
    Console.WriteLine("Fehler beim Anlegen des Passagiers!");
   }
   else
   {
    // Der erste neue Passagier muss der angelegte sein, der nun auch die ID enthält!
    pneu = antwort[0];
    Console.WriteLine("Passagier: " + pneu.ToString());
   }

   // ----------- Buchung erzeugen
   var Ergebnis = bm.CreateBuchung(FlugID, pneu.ID);
   Console.WriteLine("Ergebnis der Buchung: " + Ergebnis);

   // ----------- Flugdaten aktualisieren
   Flug fnachher = bm.GetFlug(FlugID);
   if (fnachher == null)
   {
    Console.WriteLine("Flug nicht gefunden!");
   }
   else
   {
    Console.WriteLine("Flug: " + fnachher.ToString());
   }
   bm.Close(); // WICHTIG!

  } // Ende FlugBuchenDemo()
 } // Ende Class
} // Ende Namespace
