﻿<%@ Page Language="C#" MasterPageFile="~/WWWings.master" AutoEventWireup="true" CodeFile="Buchung.aspx.cs"
 Inherits="Buchung" Title="Flugbuchung" %>

<asp:Content ID="Content1" ContentPlaceHolderID="C_Ueberschrift" runat="server">
 Flugbuchung
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="C_Inhalt" runat="Server">
 <asp:ScriptManager ID="ScriptManager1" runat="server">
 </asp:ScriptManager>
 <!-- ##################################################### Sektion 1: Flugsuche -->
 <asp:Panel ID="Panel1" runat="server" GroupingText="Flug">
  <table class="Tabelle">
   <tr>
    <td class="hell" align="center" width="80">
     Flug-ID
    </td>
    <td class="dunkel" align="center" width="60">
     <asp:TextBox ID="C_Flugnummer" runat="server" Width="50" AutoPostBack="True" OnTextChanged="C_FlugSuchen_Click"
      Text=""></asp:TextBox>
    </td>
    <td class="hell" align="center">
     Abflugort
    </td>
    <td class="dunkel" align="center">
     <asp:DropDownList ID="C_Abflugort" runat="server" Width="160" AppendDataBoundItems="true"
      AutoPostBack="True" OnSelectedIndexChanged="C_FlugSuchen_Click">
      <asp:ListItem Text="Alle" Value=""></asp:ListItem>
     </asp:DropDownList>
    </td>
    <td class="hell" align="center">
     Zielort
    </td>
    <td class="dunkel" align="center">
     <asp:DropDownList ID="C_Zielort" runat="server" Width="160" AppendDataBoundItems="true"
      AutoPostBack="True" OnSelectedIndexChanged="C_FlugSuchen_Click">
      <asp:ListItem Text="Alle" Value=""></asp:ListItem>
     </asp:DropDownList>
    </td>
    <td width="100" align="center" class="hell">
     <asp:Button ID="C_FlugSuchen" runat="server" Text="Suchen" OnClick="C_FlugSuchen_Click" />
    </td>
   </tr>
  </table>
  <asp:UpdatePanel ID="C_GefundeneFluege_UpdatePanel" runat="server">
   <ContentTemplate>
    <asp:GridView ID="C_GefundeneFluege" runat="server" AutoGenerateColumns="False" DataKeyNames="ID"
     CellPadding="4" GridLines="None" EnablePersistedSelection="true">
     <Columns>
      <asp:CommandField ButtonType="Link" HeaderText="Auswahl" SelectText="Wählen" ShowSelectButton="true" />
      <asp:BoundField DataField="ID" HeaderText="Flug-ID" />
      <asp:BoundField DataField="Route" HeaderText="Flugroute" />
      <asp:BoundField DataField="Datum" HeaderText="Datum" DataFormatString="{0:d}" />
      <asp:BoundField DataField="Datum" HeaderText="Uhrzeit" DataFormatString="{0:t}" />
      <asp:BoundField DataField="FreiePlaetze" HeaderText="Anzahl freier Plätze" />
     </Columns>
     <HeaderStyle CssClass="hell" />
     <SelectedRowStyle CssClass="dunkel" />
    </asp:GridView>
   </ContentTemplate>
   <Triggers>
    <asp:AsyncPostBackTrigger ControlID="C_Flugnummer" EventName="TextChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_Abflugort" EventName="SelectedIndexChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_Zielort" EventName="SelectedIndexChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_FlugSuchen" EventName="Click" />
   </Triggers>
  </asp:UpdatePanel>
 </asp:Panel>
 <!-- ##################################################### Sektion 2: Passagiersuche -->
 <asp:Panel ID="Panel2" runat="server" BorderStyle="None" BorderWidth="1px" GroupingText="Passagier">
  <table class="Tabelle">
   <tr>
    <td class="hell" align="center" width="80">
     Passagier-ID
    </td>
    <td class="dunkel" align="center" width="60">
     <asp:TextBox ID="C_PassagierID" runat="server" Width="50" AutoPostBack="True" OnTextChanged="C_PassagierSuchen_Click"></asp:TextBox>
    </td>
    <td class="hell" align="center">
     Namensbestandteil
    </td>
    <td class="dunkel" align="center" width="200">
     <asp:TextBox ID="C_Passagiername" runat="server" Width="200" AutoPostBack="True"
      OnTextChanged="C_PassagierSuchen_Click" Text=""></asp:TextBox>
    </td>
    <td width="100" class="hell" align="center">
     <asp:Button ID="C_PassagierSuche" runat="server" Text="Suchen" OnClick="C_PassagierSuchen_Click" />
    </td>
    <td width="100" class="hell" align="center">
     <asp:Button ID="C_NeuerPassagier" runat="server" Text="Neuer Passagier" OnClick="C_NeuerPassagier_Click" />
    </td>
   </tr>
  </table>
  <asp:UpdatePanel ID="C_GefundenePassagiere_UpdatePanel" runat="server">
   <ContentTemplate>
    <asp:GridView ID="C_GefundenePassagiere" runat="server" AutoGenerateColumns="False"
     DataKeyNames="ID" CellPadding="4" GridLines="None" EnablePersistedSelection="true">
     <Columns>
      <asp:CommandField ButtonType="Link" HeaderText="Auswahl" SelectText="Wählen" ShowSelectButton="true" />
      <asp:BoundField DataField="ID" HeaderText="Passagier-ID" />
      <asp:BoundField DataField="GanzerName" HeaderText="GanzerName" />
      <asp:BoundField DataField="Geburtsdatum" HeaderText="Geburtsdatum" DataFormatString="{0:d}" />
      <asp:BoundField DataField="Passagierstatus" HeaderText="Status" />
     </Columns>
     <HeaderStyle CssClass="hell" />
     <SelectedRowStyle CssClass="dunkel" />
    </asp:GridView>
   </ContentTemplate>
   <Triggers>
    <asp:AsyncPostBackTrigger ControlID="C_Passagiername" EventName="TextChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_PassagierID" EventName="TextChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_PassagierSuche" EventName="Click" />
   </Triggers>
  </asp:UpdatePanel>
 </asp:Panel>
 <!-- ##################################################### Sektion 3: Buchen-Aktion -->
 <asp:Panel ID="Panel3" runat="server" BorderStyle="None" BorderWidth="1px" GroupingText="Aktionen">
 
  <asp:UpdatePanel ID="C_Buchen_UpdatePanel" runat="server">
   <ContentTemplate>
    <asp:Button ID="C_Buchen" runat="server" OnClick="C_Buchen_Click" Text="Buchen" Enabled="False" />
    <asp:Label ID="C_BuchenErgebnis" runat="server" Font-Bold="true"></asp:Label>
   </ContentTemplate>
   <Triggers>
    <asp:AsyncPostBackTrigger ControlID="C_Buchen" EventName="Click" />
    <asp:AsyncPostBackTrigger ControlID="C_GefundeneFluege" 
     EventName="SelectedIndexChanged" />
    <asp:AsyncPostBackTrigger ControlID="C_GefundenePassagiere" 
     EventName="SelectedIndexChanged" />
   </Triggers>
  </asp:UpdatePanel>
 </asp:Panel>
</asp:Content>
