﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WWWings_DZS;
using WWWings_GO;
namespace WWWings_GL
{
 public class Datengenerator
 {


  static string[] Flughaefen = { "Berlin", "Frankfurt", "München", "Hamburg", "Köln/Bonn", "Rom", "London", "Paris", "Mailand", "Prag", "Moskau", "New York", "Seattle", "Essen/Mülheim", "Kapstadt", "Madrid", "Oslo", "Dallas", "Graz" };

  // Häufigste Vor- und Nachnamen
  // Quelle: http://de.wikipedia.org/wiki/Liste_der_h%C3%A4ufigsten_Familiennamen_in_Deutschland
  static string[] Nachnamen = { "Müller", "Schmidt", "Schneider", "Fischer", "Weber", "Meyer", "Wagner", "Becker", "Schulz", "Hoffmann", "Schäfer", "Koch", "Bauer", "Richter", "Klein", "Wolf", "Schröder", "Neumann", "Schwarz", "Zimmermann" };
 
  // Quelle: http://www.beliebte-vornamen.de/3467-alle-spitzenreiter.htm
  static string[] Vornamen = { "Leon", "Hannah", "Lukas", "Anna", "Leonie", "Marie", "Niklas", "Sarah", "Jan", "Laura", "Julia", "Lisa", "Kevin" };

  // Politiker-Namenskarusell :-)
  static string[] PilotenNachnamen = { "Gysi", "Stoiber", "Koch", "Steinmeyer", "Schröder", "Merkel", "Westerwelle", "Beck", "Lafontaine", "Trittin", "Roth" };
  static string[] PilotenVornamen = { "Edmund", "Olaf", "Roland", "Gerhard", "Angela", "Joschka", "Guido", "Gregor", "Kurt", "Frank-Walter", "Oskar", "Jürgen", "Claudia" };

  const int ANZFluege = 200;
  const int ANZPass = 200;
  static string[] PassagierStatus = { "A", "B", "C" };

  static System.Random rnd = new Random(DateTime.Now.Millisecond);

  public static void Init_DB()
  {


   Console.WriteLine("DB WWWings Mini Initialisieren");


   WWWingsModellContainer db = new WWWingsModellContainer();


   Console.WriteLine("Flüge zu Beginn: " + db.FlugSet.Count());
   Console.WriteLine("Passagiere zu Beginn: " + db.PersonSet.Count());
   // Alle Buchungen löschen!
   db.ExecuteStoreCommand("Delete from PassagierFlug");
   db.ExecuteStoreCommand("Delete from FlugSet");
   db.ExecuteStoreCommand("Delete from PersonSet_Passagier");
   db.ExecuteStoreCommand("Delete from PersonSet_Pilot");
   db.ExecuteStoreCommand("Delete from PersonSet");

   Console.WriteLine("Flüge nach Löschen: " + db.FlugSet.Count());
   Console.WriteLine("Personen nach Löschen: " + db.PersonSet.Count());

   Init_Passagiere(db);
   Init_Piloten(db);
   Init_Fluege(db);
  // Init_Buchungen(db);

  }

  /// <summary>
  /// Menge von Flügen erzeugen
  /// </summary>
  private static System.Random Init_Fluege(WWWingsModellContainer db)
  {
   Console.WriteLine("Erzeuge Flüge...");

   var Fluege = from f in db.FlugSet select f;
   int Start = 100;

   for (int i = Start; i < (Start + ANZFluege); i++)
   {

    if (i % 100 == 0) Console.WriteLine("FLUG #" + i);
    Flug FlugNeu = new Flug();
    FlugNeu.ID = i;
    FlugNeu.Abflugort = Flughaefen[rnd.Next(0, Flughaefen.Length - 1)];
    FlugNeu.Zielort = Flughaefen[rnd.Next(0, Flughaefen.Length - 1)]; ;
    if (FlugNeu.Abflugort == FlugNeu.Zielort) { i--; continue; } // Keine Rundflüge!
    FlugNeu.FreiePlaetze = Convert.ToInt16(new System.Random(i).Next(250));
    FlugNeu.Plaetze = 250;
    FlugNeu.Datum = DateTime.Now.AddDays((double)FlugNeu.FreiePlaetze).AddMinutes((double)FlugNeu.FreiePlaetze * 7);

    FlugNeu.PilotId = db.PersonSet.OfType<Pilot>().ToList()[rnd.Next(db.PersonSet.OfType<Pilot>().Count() - 1)].ID;

    db.FlugSet.AddObject(FlugNeu);
    try
    {
     db.SaveChanges();
    }
    catch (Exception ex)
    {
     Console.WriteLine("FLUG:   " + FlugNeu.ID + ":" + FlugNeu.Abflugort + " -> " + FlugNeu.Zielort + ": " + ex.Message.ToString());

    }

   }
   Console.WriteLine("Flüge nach dem Einfügen: " + db.FlugSet.Count());
   return rnd;
  }

  private static void Init_Buchungen(WWWingsModellContainer db)
  {
   int k = 0;
   System.Random rnd5 = new Random();
   Console.WriteLine("Erzeuge Buchungen...");
   var Fluege2 = from f in db.FlugSet select f;

   Passagier[] PassagierArray = db.PersonSet.OfType<Passagier>().ToArray();
   foreach (Flug f in Fluege2.ToList())
   {
    k++;
    if (k % 100 == 0) Console.WriteLine(k);

    for (int j = 1; j < 10; j++)
    {
     Random rnd2 = new System.Random(System.DateTime.Now.Millisecond);
     // Wähle Zufällig einen Passagier
     Passagier p = PassagierArray[Convert.ToInt16(rnd5.Next(PassagierArray.Count()))];
     Console.WriteLine("BUCHUNG: " + f.ID + " ->  " + p.ID);
     // Buchung anlegen
     f.Passagier.Add(p);

     try // Weil doppelte möglich sind durch Zufallsauswahl!
     {
      db.SaveChanges();
     }
     catch (Exception ex)
     {
      Console.WriteLine(ex.InnerException.Message);
      f.Passagier.Remove(p);
     }
    }
   }
  }


  private static void Init_Piloten(WWWingsModellContainer db)
  {
   Console.WriteLine("Erzeuge Piloten...");

   for (int PNummer = 1; PNummer <= ANZPass; PNummer++)
   {
    string Vorname = PilotenVornamen[rnd.Next(0, PilotenVornamen.Length - 1)]; ;
    string Nachname = PilotenNachnamen[rnd.Next(0, PilotenNachnamen.Length - 1)]; ;
    Pilot p = new Pilot();
   // p.ID = 1000 + PNummer;
    p.Name = Nachname;
    p.Vorname = Vorname;
    p.Geburtsdatum = new DateTime(1940, 1, 1).AddDays(Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(20000)));
    p.Eingestellungsdatum = DateTime.Now.AddDays(-rnd.Next(365));
    db.PersonSet.AddObject(p);
    db.SaveChanges();

    System.Console.WriteLine("PILOT: " + PNummer + ": " + Vorname + " " + Nachname);

   }

   Console.WriteLine("Piloten nach dem Einfügen: " + db.PersonSet.OfType<Pilot>().Count());
  }


  private static void Init_Passagiere(WWWingsModellContainer db)
  {
   // Passagiere Anlegen
   Console.WriteLine("Erzeuge Passagiere...");



   System.Random rnd2 = new Random();

   for (int PNummer = 1; PNummer <= ANZPass; PNummer++)
   {
    string Vorname = Vornamen[rnd2.Next(0, Vornamen.Length - 1)]; ;
    string Nachname = Nachnamen[rnd2.Next(0, Nachnamen.Length - 1)]; ;
    Passagier p = new Passagier();
  //  p.ID = 1;
    p.Name = Nachname;
    p.Vorname = Vorname;
    p.Geburtsdatum = new DateTime(1940, 1, 1).AddDays(Convert.ToInt32(new Random(DateTime.Now.Millisecond).Next(20000)));
    p.ID = PNummer;

    p.PassagierStatus = PassagierStatus.ElementAt(rnd.Next(3));
    db.PersonSet.AddObject(p);


    db.SaveChanges();

    System.Console.WriteLine("PASSAGIER: " + PNummer + ": " + Vorname + " " + Nachname);

   }
   Console.WriteLine("Passagiere nach dem Anfügen: " + db.PersonSet.OfType<Passagier>().Count());
  }
 }
}
