package net.reppa.util.remotedelegates
{
	import mx.rpc.AbstractOperation;
	import mx.rpc.AsyncToken;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.mxml.RemoteObject;
	
	public class RemotingDelegate extends Delegate implements IDelegate
	{
		private var m_operationName:String;
		private var m_arguments:Array;
		private var m_remoteObject:RemoteObject;
		private var m_remoteDestination:String;
		private var m_token:AsyncToken;
		
		
		private static var _defaultRemoteURL:String;
		private static var _defaultDestination:String;
		
		public function RemotingDelegate( operationname:String, arguments:Array=null, responder:IDelegateResponder=null, serviceid:String=null, destination:String=null)
		{
			super(serviceid, responder);

			m_remoteDestination = destination;
			m_operationName = operationname;
			m_arguments = arguments;
		}
		
		public static function setRemoteURL( url:String ):void
		{
			_defaultRemoteURL = url;
		}
		
		public static function setDefaultDestination( destination:String ):void
		{
			_defaultDestination = destination;
		}
		
		
		public function execute():void
		{

			 m_remoteObject = new RemoteObject( m_remoteDestination ? m_remoteDestination:_defaultDestination );
			
			// Set Endpoint
			m_remoteObject.endpoint = _defaultRemoteURL;
			m_remoteObject.showBusyCursor = true;
			
			// Register Listeners
			m_remoteObject.addEventListener( ResultEvent.RESULT, onResult );
			m_remoteObject.addEventListener( FaultEvent.FAULT, onFault );
			
			// Call Remote Function
			var operation:AbstractOperation = m_remoteObject.getOperation( m_operationName );
			
			if(m_arguments)
				operation.arguments = m_arguments;
			m_token = operation.send();
			
		}
	
		
		
		 private function cleanUp():void
		{
			m_remoteObject.removeEventListener( ResultEvent.RESULT, onResult );
			m_remoteObject.removeEventListener( FaultEvent.FAULT, onFault );
			
			m_remoteObject.disconnect();
		}
		
		private function onResult( event:ResultEvent ):void
		{
			cleanUp();
			m_responder.onDelegateResult( m_serviceID, event.result );
		}
		
		private function onFault( event:FaultEvent ):void
		{
			cleanUp();
			m_responder.onDelegateFault( m_serviceID, event.fault );
		} 
		
	}

}