package net.reppa.util.remotedelegates
{
	import flash.errors.IOError;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.net.URLLoader;
	import flash.net.URLLoaderDataFormat;
	import flash.net.URLRequest;
	import flash.net.URLRequestMethod;
	
	public class UrlLoaderDelegate extends Delegate implements IDelegate
	{
		
		private var m_dataFormat:String;
		private var m_loader:URLLoader;
		private var m_request:URLRequest;
		
		public function UrlLoaderDelegate(
										url:String, 
										responder:IDelegateResponder=null, 
										serviceid:String="",
										method:String=URLRequestMethod.GET, 
										format:String=URLLoaderDataFormat.TEXT)
										
		{
			super(serviceid, responder);
			
			m_request = new URLRequest( url );
			m_request.method = method;
			m_request.data = new Object();
			m_dataFormat = format;
			
		}
		
		public function setParameter( property:String, value:Object ):void
		{
			m_request.data[ property ] = value; 
		}
		
		public function execute():void
		{
			m_loader = new URLLoader();
			m_loader.dataFormat = m_dataFormat;
			m_loader.addEventListener( SecurityErrorEvent.SECURITY_ERROR, onSecurityError );
			m_loader.addEventListener( IOErrorEvent.IO_ERROR, onIOError );
			m_loader.addEventListener( Event.COMPLETE, onComplete );
			m_loader.load( m_request );
		}
		
		private function cleanUp():void
		{
			m_loader.removeEventListener( SecurityErrorEvent.SECURITY_ERROR, onSecurityError );
			m_loader.removeEventListener( IOErrorEvent.IO_ERROR, onIOError );
			m_loader.removeEventListener( Event.COMPLETE, onComplete );
		}
		
		private function onComplete( event:Event ):void
		{
			cleanUp();
			m_responder.onDelegateResult( m_serviceID, m_loader.data );
		}
		
		private function onSecurityError( event:SecurityErrorEvent ):void
		{
			cleanUp();
			throw( new SecurityError( "Security error " + event + " has occured.") );
		}
		
		private function onIOError( event:IOErrorEvent ):void
		{
			cleanUp();
			throw( new IOError( "IO error " + event + " has occured.") );
		}
		
	}
}