package loginexample.model
{
	import loginexample.model.vo.ConfigVO;
	
	import net.reppa.util.remotedelegates.IDelegateResponder;
	import net.reppa.util.remotedelegates.UrlLoaderDelegate;
	
	import org.puremvc.as3.interfaces.IProxy;
	import org.puremvc.as3.patterns.proxy.Proxy;

	public class ConfigProxy extends Proxy implements IProxy, IDelegateResponder
	{
		
		public static const NAME:String = "configProxy";
		
		/*
		 * Notification IDs
		 */
		public static const CONFIG_LOADED:String 	= NAME + ".configLoaded";
		
		
		public function ConfigProxy(  )
		{
			super( NAME );
		}
		
		/* 
		 * Lädt die config.xml 
		 */
		public function loadConfig():void
		{
			new UrlLoaderDelegate( "assets/config.xml", this ).execute();
		}
		
		/* 
		 * nachdem die config.xml erfolgreich geladen wurde 
		 */
		public function onDelegateResult( serviceid:String, data:Object ):void
		{
			// Instanziiere ConfigVO
			var configvo:ConfigVO = new ConfigVO( new XML( data ) );
			
			// Cache ConfigVO
			setData( configvo );
			
			// Sende Notification
			sendNotification( CONFIG_LOADED, ConfigData );
		}
		
		
		public function get ConfigData():ConfigVO
		{
			return data as ConfigVO;
		}
		
		/* 
		 * bei einem Fehler wärende des Ladeprozesses
		 */
		public function onDelegateFault(serviceid:String, data:Object):void
		{
			
		}
		
	}
}