#ifndef PIMPL_SHAPE_P_H__
#define PIMPL_SHAPE_P_H__

#include "shape.h"

#include <QPen>
#include <QBrush>

class Shape::Private {
    friend class ::Shape;
    Shape * _q;
    QPen pen;
    QBrush brush;
public:
    Shape * q_func() { return _q; }
    const Shape * q_func() const { return _q; }

    explicit Private( Shape * qq )
        : _q( qq ),
          pen( Qt::black ),
          brush( Qt::NoBrush )
    {
        // don't touch 'q' here!
    }

    // must be virtual, even though empty, otherwise ~Shape deleting
    // _d will lead to undefined behaviour:
    virtual ~Private() {}

    void init() {}

    virtual void doDraw( QPainter * p ) const;
};

Shape::Shape( Private * d )
    : _d( d )
{

}

#endif /* PIMPL_SHAPE_P_H__ */
