#ifndef PIMPL_RECTANGLE_P_H__
#define PIMPL_RECTANGLE_P_H__

#include "rectangle.h"
#include "shape_p.h"

#include <QRectF>

class Rectangle::Private : public Shape::Private {
    friend class ::Rectangle;
    QRectF rect;
public:
    Rectangle * q_func() { return static_cast<Rectangle*>( Shape::Private::q_func() ); }
    const Rectangle * q_func() const { return static_cast<const Rectangle*>( Shape::Private::q_func() ); }

    explicit Private( const QRectF & r, Rectangle * qq )
        : Shape::Private( qq ),
          rect( r )
    {
        // don't touch 'q_func' here!
    }

    void init() {}

    /* reimp */ void doDraw( QPainter * p ) const;
};

Rectangle::Private * Rectangle::d_func() { return static_cast<Private*>( Shape::d_func() ); }
const Rectangle::Private * Rectangle::d_func() const { return static_cast<const Private*>( Shape::d_func() ); }

Rectangle::Rectangle( Private * d )
    : Shape( d )
{

}

#endif /* PIMPL_RECTANGLE_P_H__ */
