#include "rectangle_p.h"

#include <QPainter>

Rectangle::Rectangle()
    : Shape( new Private( QRectF(), this ) )
{
    d_func()->init();
}

Rectangle::Rectangle( const QRectF & r )
    : Shape( new Private( r, this ) )
{
    d_func()->init();
}

Rectangle::~Rectangle() {}

void Rectangle::Private::doDraw( QPainter * p ) const {
    p->drawRect( rect );
}

Rectangle * Rectangle::clone() const {
    return new Rectangle( d_func()->rect );
}

QRectF Rectangle::rect() const {
    return d_func()->rect;
}

void Rectangle::setRect( const QRectF & rect ) {
    d_func()->rect = rect;
}
