/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Date;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import net.contrapunctus.lzma.LzmaOutputStream;

public class CFileTools {
    static final byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    static final int iterationCount = 23;

    public static byte[] readFromInputStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = inputStream.read(byArray, n2, n - n2)) > 0; n2 += n3) {
        }
        if (n2 == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, n2);
        byte[] byArray2 = new byte[n2];
        byteBuffer.get(byArray2, 0, n2);
        return byArray2;
    }

    public static void writeIntArray(int[] nArray, OutputStream outputStream) throws IOException {
        for (int n : nArray) {
            outputStream.write(n & 0xFF);
        }
    }

    public static byte[] compressBlock(byte[] byArray) throws IOException {
        return CFileTools.compressBlock(byArray, false);
    }

    public static byte[] compressBlock(byte[] byArray, boolean bl) throws IOException {
        byte[] byArray2 = new byte[2 * byArray.length];
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            LzmaOutputStream lzmaOutputStream = new LzmaOutputStream(byteArrayOutputStream);
            lzmaOutputStream.write(byArray, 0, byArray.length);
            lzmaOutputStream.flush();
            lzmaOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        Deflater deflater = new Deflater(9);
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        return byteBuffer.put(byArray2, 0, n).array();
    }

    public static byte[] decompressBlock(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[0x2000000];
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 0, byArray.length);
        int n = inflater.inflate(byArray2);
        inflater.end();
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        return byteBuffer.put(byArray2, 0, n).array();
    }

    public static byte[] encryptBlock(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return cipher.doFinal(byArray);
    }

    public static byte[] decryptBlock(Cipher cipher, byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return cipher.doFinal(byArray);
    }

    public static String toHexDump(byte[] byArray) {
        return CFileTools.toHexDump(byArray, 0);
    }

    public static String toHexDump(byte[] byArray, int n) {
        String string = "";
        int n2 = n == 0 || byArray.length < n ? byArray.length : n;
        int n3 = n2 / 16 + (n2 % 16 > 0 ? 1 : 0);
        for (int i = 0; i < n3; ++i) {
            int n4 = i + 1 == n3 && byArray.length % 16 > 0 ? byArray.length % 16 : 16;
            string = string + String.format("%06x: ", i * 16);
            for (int j = 0; j < 16; ++j) {
                string = j >= n4 ? string + "   " : string + String.format("%02x ", byArray[i * 16 + j] & 0xFF);
                if (j != 7) continue;
                string = string + "- ";
            }
            string = string + "\n";
        }
        return string;
    }

    public static void writeLengthToFile(int n, OutputStream outputStream) throws Exception {
        for (int i = 0; i < 4; ++i) {
            outputStream.write(n >>> (3 - i) * 8 & 0xFF);
        }
        outputStream.flush();
    }

    public static void longToByteArray(long l, byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)(l >>> (3 - i) * 8) & 0xFF;
            byArray[n + i] = (byte)n3;
        }
    }

    public static void longToIntArray(long l, int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            nArray[n + i] = n3 = (int)(l >>> (n2 - 1 - i) * 8) & 0xFF;
        }
    }

    public static void intArrayToByteArray(int[] nArray, byte[] byArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i] & 0xFF;
            byArray[n + i] = (byte)n2;
        }
    }

    public static long byteArrayToLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[n + i] & 0xFF);
        }
        return l;
    }

    public static int byteArrayToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }

    public static Cipher initEncryption(String string) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), salt, 23);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(salt, 23);
        cipher.init(1, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }

    public static Cipher initDecryption(String string) throws Exception {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), salt, 23);
        SecretKey secretKey = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(pBEKeySpec);
        Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm());
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(salt, 23);
        cipher.init(2, (Key)secretKey, pBEParameterSpec);
        return cipher;
    }

    public static String printDottedNumber(long l) {
        StringBuffer stringBuffer = new StringBuffer("   .   .   ");
        int[] nArray = new int[]{10, 9, 8, 6, 5, 4, 2, 1, 0};
        int n = 0;
        while (true) {
            stringBuffer.setCharAt(nArray[n], (char)(48L + l % 10L));
            if ((l /= 10L) == 0L) {
                for (int i = nArray[n] - 1; i >= 0; --i) {
                    stringBuffer.setCharAt(i, ' ');
                }
                break;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static boolean byteArrayCompare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void setIconImageFromResource(JFrame jFrame, String string) throws Exception {
        InputStream inputStream = jFrame.getClass().getResourceAsStream("images/" + string);
        if (inputStream != null) {
            int n = 0;
            byte[] byArray = new byte[24000];
            try {
                int n2;
                while ((n2 = inputStream.read(byArray, n, byArray.length - n)) > 0) {
                    n += n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage(byArray2));
        } else {
            jFrame.setIconImage(Toolkit.getDefaultToolkit().createImage("Images/" + string));
        }
    }

    public static void initTable(JTable jTable, String[] stringArray, int n, boolean bl) {
        CFileTools.initTable(jTable, stringArray, n, bl, null);
    }

    public static void initTable(JTable jTable, String[] stringArray, int n, boolean bl, Font font) {
        Object[] objectArray;
        int n2 = stringArray.length;
        Object[][] objectArray2 = new Object[n][n2];
        boolean[] blArray = new boolean[n2];
        Class[] classArray = new Class[n2];
        int[] nArray = new int[n2];
        Object[] objectArray3 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray = stringArray[i].split(";");
            switch (objectArray[1].toUpperCase().charAt(0)) {
                case 'B': {
                    classArray[i] = Boolean.class;
                    break;
                }
                case 'I': {
                    classArray[i] = Integer.class;
                    break;
                }
                case 'S': {
                    classArray[i] = String.class;
                    break;
                }
                case 'D': {
                    classArray[i] = Date.class;
                    break;
                }
                default: {
                    classArray[i] = String.class;
                }
            }
            blArray[i] = bl;
            if (objectArray.length > 3) {
                blArray[i] = objectArray[3].startsWith("1");
            }
            nArray[i] = Integer.parseInt(objectArray[0]);
            objectArray3[i] = objectArray[2];
        }
        final Class[] classArray2 = (Class[])classArray.clone();
        objectArray = (boolean[])blArray.clone();
        jTable.removeAll();
        jTable.setModel(new DefaultTableModel(objectArray2, objectArray3, (boolean[])objectArray){
            private static final long serialVersionUID = 7L;
            final /* synthetic */ boolean[] val$canEdit;
            {
                this.val$canEdit = blArray;
                super(objectArray, objectArray2);
            }

            public Class getColumnClass(int n) {
                return classArray2[n];
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return this.val$canEdit[n2];
            }
        });
        for (int i = 0; i < n2; ++i) {
            jTable.getColumnModel().getColumn(i).setMaxWidth(nArray[i]);
            jTable.getColumnModel().getColumn(i).setResizable(false);
        }
        if (font != null) {
            jTable.setFont(font);
        }
    }
}

