/*
 * Decompiled with CFR 0.152.
 */
package net.nieden.FileCrypter;

import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.crypto.Cipher;
import net.nieden.FileCrypter.CFileTools;
import net.nieden.FileCrypter.IFileProgressIndicator;

public class CFileBlockProcessor {
    static final int STATUS_IDLE = 1;
    static final int STATUS_WORKING = 2;
    static final int STATUS_WAITING = 3;
    static final int STATUS_FINISHED = 4;
    int numBlocks;
    int maxThreads;
    boolean encrypt;
    ArrayList<blockProcThread> blockProcThreadList = new ArrayList();
    IFileProgressIndicator pgrsInidicator = null;

    public CFileBlockProcessor(int n, boolean bl, IFileProgressIndicator iFileProgressIndicator) {
        this.numBlocks = n;
        this.maxThreads = Runtime.getRuntime().availableProcessors();
        this.encrypt = bl;
        this.pgrsInidicator = iFileProgressIndicator;
        for (int i = 0; i < n; ++i) {
            this.blockProcThreadList.add(new blockProcThread(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkingThreadCount() {
        int n = 0;
        ArrayList<blockProcThread> arrayList = this.blockProcThreadList;
        synchronized (arrayList) {
            for (blockProcThread blockProcThread2 : this.blockProcThreadList) {
                if (blockProcThread2.status != 2) continue;
                ++n;
            }
        }
        return n;
    }

    public void waitForLastBlock() throws Exception {
        blockProcThread blockProcThread2 = this.blockProcThreadList.get(this.numBlocks - 1);
        while (blockProcThread2.status != 4) {
            Thread.sleep(100L);
        }
    }

    public class blockProcThread
    extends Thread {
        Integer blockID;
        Integer status = 1;
        byte[] inBuffer = null;
        FileOutputStream fos = null;
        boolean compress = false;
        boolean is7zip = false;
        Cipher cipher;

        public blockProcThread(int n) {
            this.blockID = n;
        }

        public void startWorking(byte[] byArray, String string, FileOutputStream fileOutputStream) throws Exception {
            this.startWorking(byArray, false, false, string, fileOutputStream);
        }

        public void startWorking(byte[] byArray, boolean bl, String string, FileOutputStream fileOutputStream) throws Exception {
            this.startWorking(byArray, bl, false, string, fileOutputStream);
        }

        public void startWorking(byte[] byArray, boolean bl, boolean bl2, String string, FileOutputStream fileOutputStream) throws Exception {
            this.inBuffer = byArray;
            this.fos = fileOutputStream;
            this.cipher = CFileBlockProcessor.this.encrypt ? CFileTools.initEncryption(string) : CFileTools.initDecryption(string);
            this.compress = bl;
            this.is7zip = bl2;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.status;
                synchronized (object) {
                    this.status = 2;
                }
                object = null;
                if (this.compress && CFileBlockProcessor.this.encrypt) {
                    this.inBuffer = CFileTools.compressBlock(this.inBuffer, this.is7zip);
                }
                object = CFileBlockProcessor.this.encrypt ? CFileTools.encryptBlock(this.cipher, this.inBuffer) : CFileTools.decryptBlock(this.cipher, this.inBuffer);
                if (this.compress && !CFileBlockProcessor.this.encrypt) {
                    object = CFileTools.decompressBlock((byte[])object);
                }
                Object object2 = this.status;
                synchronized (object2) {
                    this.status = 3;
                }
                if (this.blockID > 0) {
                    while (true) {
                        object2 = CFileBlockProcessor.this.blockProcThreadList.get(this.blockID - 1);
                        if (((blockProcThread)object2).status == 4) break;
                        Thread.sleep(10L);
                    }
                }
                object2 = this.fos;
                synchronized (object2) {
                    for (int i = 0; i < 4; ++i) {
                        this.fos.write(((Object)object).length >>> (3 - i) * 8 & 0xFF);
                    }
                    this.fos.write((byte[])object, 0, ((Object)object).length);
                    this.fos.flush();
                    if (CFileBlockProcessor.this.pgrsInidicator != null) {
                        CFileBlockProcessor.this.pgrsInidicator.progressIndicator(this.blockID + 1, CFileBlockProcessor.this.numBlocks);
                    }
                }
                object2 = this.status;
                synchronized (object2) {
                    this.status = 4;
                }
            }
            catch (Exception exception) {
                System.err.println("blockProcThread.run(): terminating due to exception: " + exception.getMessage());
                return;
            }
        }
    }
}

