#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#include <winsock.h>
#else
#include <netdb.h>
#include <errno.h>
#include <sys/socket.h>
#include <netinet/in.h>
#endif

#define	BUFFER_SZ	1024*1024

int	Connect(char *, int);
int	crackURL(char *, char *, char *);
int	ReceiveHtmlDocument(char *, char **, int *);
int	receiveLine(int, char *, int);
void	usage();

char appName[]="getURL";

int main(int argc, char *argv[]) {
	int s, l, argcnt=1;
	char	*url, *buffer;

	if (argc < 2) usage();
	#ifdef WIN32
	{
		WSADATA wsaData;
		if (WSAStartup(0x0202, &wsaData)) {
        	fprintf (stderr,"WSAStartup() FAILED.\n");
        }
    }
	#endif
	while (--argc) {
		url=argv[argcnt++];
		if (ReceiveHtmlDocument(url, &buffer, &l)<0) {
			exit(errno);
		}
		printf ("%d bytes received from %s\n", l, url);
		close(s);
	}
}

int Connect(char *host, int port) {
	struct hostent *h;
	struct sockaddr_in addr;
	int s;

	if ((h=gethostbyname(host))==NULL) {
		fprintf(stderr,"gethostbyname() FAILED with %d: %s\n", errno, strerror(errno));
		return -1;
	}
	if ((s=socket(AF_INET,SOCK_STREAM,0))<0) {
		fprintf(stderr,"socket() FAILED with %d: %s\n", errno, strerror(errno));
		return -1;
	}
	memset(&addr, 0, sizeof(struct sockaddr_in));
	addr.sin_family=AF_INET;
	memcpy(&addr.sin_addr,h->h_addr_list[0],h->h_length);
	addr.sin_port=htons(80);
	if (connect(s, (struct sockaddr *) &addr, sizeof(struct sockaddr_in))<0) {
		fprintf(stderr,"connect() FAILED with %d: %s\n", errno, strerror(errno));
		return -1;
	}
	return s;
}

int ReceiveHtmlDocument(char *url, char **docBuffer, int *plength) {
	int s, pos, line, rc, l, cl, redirect=0;
	char hostname[200], urlb[2000];
	char	*ss, *buffer, tbuffer[5000];

	if (crackURL(url, hostname, urlb)<=0) {
		return -1;
	}
	if ((s=Connect(hostname, 80))<0) {
		return -1;			
	}
	sprintf(tbuffer,"GET %s HTTP/1.1\r\nHost: %s\r\nUser-Agent: %s\r\nAccept: text/html\r\nConnection: close\r\n\r\n",
		urlb, hostname, appName);
	send(s, tbuffer, strlen(tbuffer), 0);
	for (line=cl=0;;line++) {
		// Receive HTTP Header
		if ((l=receiveLine(s, tbuffer, sizeof(tbuffer)))<=0) {
			fprintf(stderr,"unexpected EOF reading from socket!\n");
			return -1;
		}
		if (line==0) {
			// the 1st line: get HTTP Return Code ...
			if (strncmp(tbuffer,"HTTP",4) || (ss=strchr(tbuffer,' '))==NULL) {
				fprintf(stderr,"expected HTTP return code!\n");
				return -1;
			}
			rc=atoi(ss+1);
			if (rc >= 400) {
				fprintf(stderr,"Web Server Returned HTTP %d!\n", rc);
				return -1;
			}
			if (rc==301 || rc==302) {
				redirect++;
			}
			continue;
		}
		printf("%s\n", tbuffer);
		if (tbuffer[0]==0) break;
		if (redirect && !strncmp(tbuffer,"Location:",9)) {
			printf ("Redirecting to %s ...\n", &tbuffer[10]);
			return ReceiveHtmlDocument(&tbuffer[10], docBuffer, plength);
		}
		if (!strncmp(tbuffer,"Content-Length:",15)) {
			cl=atoi(&tbuffer[15]);
		}
	}
	if (cl > 0) {
		int btogo=cl;
		buffer=malloc(cl);
		pos=0;

		while (btogo > 0) {
			if ((l=recv(s, buffer+pos, btogo, 0))<=0) {
				fprintf(stderr,"unexpected EOF reading from socket!\n");
				return -1;
			}
			pos+=l; btogo-=l;
		}
		FILE *fp=fopen("page.html","w");
		fwrite(buffer,1,pos,fp);
		fclose(fp);
		*plength=cl;
		*docBuffer=buffer;
		return cl;
	}
	/**
	 * no content length given - receive html document up to the terminating "</html>" Tag
	 */
	 printf("Scanning for </html> tag ...\n");
	 *plength=0;
	 buffer=NULL;
	 for (pos=0;;pos+=(l+2)) {
	 	if ((l=receiveLine(s, tbuffer, sizeof(tbuffer)))<=0) {
			fprintf(stderr,"unexpected EOF reading from socket!\n");
			return -1;
		}
		buffer=realloc(buffer,pos+(l+3));
		memcpy(buffer+pos, tbuffer, l);
		memcpy(buffer+pos+l,"\r\n\000", 3);
		*plength+=(l+2);
		if (strstr(tbuffer,"</html>")!=NULL) {
			*docBuffer=buffer;
			break;
		}
	}
	return l;
}

int crackURL(char *url, char *hostname, char *urls) {
	char *s, *d;
	int l;

	if ((s=strstr(url, "://"))==NULL) {
		fprintf(stderr,"missing protocol unit in URL!\n");
		return -1;
	}
	if ((d=strchr(s+3, '/'))==NULL) {
		fprintf(stderr,"missing URL unit in URL!\n");
		return -1;
	}
	l=(d-(s+3)); strncpy(hostname,s+3,l); hostname[l]=0;
	strcpy(urls, d);
	return l;
}

int receiveLine(int s, char *line, int maxChars) {
	int l, ch, pos=0;

	memset(line, 0, maxChars);
	for (;;) {
		if ((l=recv(s,&line[pos],1, 0))<=0) {
			return -1;
		}
		switch(ch=line[pos]) {
		case 13:line[pos]=0;
			break;
		case 10:line[pos]=0;
			break;
		}
		pos++;
		if (ch == 10) {
			return pos;
		}
		if (pos==maxChars) return pos;
	}
}

void usage() {
	fprintf(stderr,"usage: %s URL ...\n", appName);
	exit(1);
}
