public class CGetURL {
	final static String invalidURL="invalid URL String!",
		invalidReturnValue="invalid/unexpected return Value!";
	int port=80;
	String hostname, document;

	public CGetURL(String u) throws Exception {
		int idx;
		/**
		 * 1st split the URL into protocol, host, document path
		 */
		String[] sList=u.split("://");
		if (sList.length != 2) throw new Exception(invalidURL);
		if ((idx=sList[1].indexOf('/')) < 0) throw new Exception(invalidURL);
		hostname=sList[1].substring(0,idx);
		document=sList[1].substring(idx);
	}

	public String receiveHtmlDocument() throws Exception {
		HttpSocket s=new HttpSocket(hostname, port);
		return s.readDocument(document);
	}

	public static void main(String[] args) {
		if (args.length < 1) {
			System.err.println("usage: java "+CGetURL.class.getSimpleName()+" URL ...");
		} else for (String s: args) {
			try {
				CGetURL cg=new CGetURL(s);
				String str=cg.receiveHtmlDocument();
				System.out.printf("%d byte(s) received from %s!\n", str.length(), cg.hostname);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
