#include <QtGui/QWidget>
#include <QtGui/QPainter>
#include <QtGui/QMouseEvent>
#include "data.h"
#include "view.h"

View::View(Data *p_data, QWidget *parent) : QWidget(parent) {

  data = p_data;
}

void View::paintEvent(QPaintEvent *) {

  QPainter p;
  
  p.begin(this);
  p.drawImage(0, 0, *data->getImage());
  p.end();
}

void View::updateSize() {

  setMinimumSize(data->getImageSize());
  setMaximumSize(data->getImageSize());
  repaint();
}
