#include <QtGui/QApplication>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>   
#include <QtGui/QMenu>   
#include <QtCore/QString>   
#include <QtCore/QThread>
#include "data.h"
#include "gui.h"

int main(int argc, char *argv[])  
{
  int threadCount;

  QApplication myApp(argc, argv);
  QMainWindow top;
  top.setWindowTitle("QParallelMandelbrot    (c)2012 by Matthias Nagorni");
  if (argc > 1) {
    threadCount = QString(argv[1]).toInt();
  } else {
    threadCount = QThread::idealThreadCount();
  } 
  Gui *gui = new Gui(threadCount, &top);
  QMenu *fileMenu = top.menuBar()->addMenu("&Datei");
  fileMenu->addAction("Bild &Speichern", gui, SLOT(saveImage()));
  fileMenu->addSeparator();
  fileMenu->addAction("&Beenden", &myApp, SLOT(quit()));
  QMenu *imageMenu = top.menuBar()->addMenu("&Bild");
  imageMenu->addAction("Bild &Skalieren", gui, SLOT(scaleImage()));
  top.setCentralWidget(gui); 
  top.setGeometry(100, 100, 800, 600);
  top.show();
  return myApp.exec(); 
}
