#ifndef GUI_H
#define GUI_H

#include <QtGui/QWidget>
#include <QtGui/QImage>
#include <QtGui/QLabel>
#include <QtCore/QList>
#include <QtCore/QTime>
#include <QtCore/QTimer>
#include "data.h"
#include "view.h"
#include "calc.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    View *view;
    QList<Calc *> calc;
    QTime time;
    QTimer *timer;
    QLabel *label;
    int readyCounter;

  public:
    Gui(int threadCount, QWidget* parent=0);
    ~Gui();
    
  public slots: 
    void saveImage();
    void scaleImage();
    void calcFinished();
    void updateStatus();
};

#endif
