#include <math.h>
#include "calc.h"

Calc::Calc(Data *p_data, int p_id, QThread *parent) : QThread(parent) {

  data = p_data;
  id = p_id;
}

int Calc::mandelPixel(double c_re, double c_im) {

  int iteration;
  double z_re1, z_re2, z_im1, z_im2, b;
  
  z_re1 = 0;
  z_im1 = 0;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < 100.0) && (iteration < maxIterations)) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }   
  return(iteration);
}

void Calc::run() {

  int i1, i2, l, w, h, s;
  int pixel;
  double z_re, z_im, xScale, yScale, xOfs, yOfs;
  QRgb colorPixel;

  w = data->getImage()->width();
  h = data->getImage()->height();
  for (i1 = 0; i1 < chunkLen; i1++) {
    chunkBuf[i1] = (int *)malloc(w * sizeof(int));  
  }  
  xOfs = -(double)w/1.25;
  yOfs = -(double)h/2.0;
  xScale = 2.6 / (double)w;
  yScale = 2.6 / (double)h;
  while (data->getNextChunk(s, l) && !data->shutdownFlag) {
    for (i1 = 0; i1 < l; i1++) {
      for (i2 = 0; i2 < w; i2++) {
        z_re = (double)(i2 + xOfs) * xScale;
        z_im = (double)(s + i1 + yOfs) * yScale;
        pixel = mandelPixel(z_re, z_im);
        chunkBuf[i1][i2] = pixel;          
      }
    }
    data->calcMutex.lock();
    for (i1 = 0; i1 < l; i1++) {
      for (i2 = 0; i2 < w; i2++) {
        colorPixel = data->getPalette(chunkBuf[i1][i2]).rgb();
        data->getImage()->setPixel(i2, s + i1, colorPixel);
      }
    }  
    data->calcMutex.unlock();
  }  
  for (i1 = 0; i1 < chunkLen; i1++) {
    free(chunkBuf[i1]); 
  }  
}
