#include "movie.h"

Movie::Movie(Data *p_data, QThread *parent) : QThread(parent) {

  data = p_data;
}

void Movie::initMovie() {

  int i;

  for (i = 0; i < data->getThreadCount(); i++) {
    frame << new Frame(data, i);
    frame.at(i)->start();
  }
}

void Movie::run() {

  int i;

  while(data->getFrameCount() < data->getMaxFrames() && !data->shutdownFlag) {
    data->movieMutex.lock();
    data->frameWait.wakeAll();
    data->movieWait.wait(&data->movieMutex);
    data->movieMutex.unlock();
    data->frameReady();
    data->saveFrame();
    data->nextFrame();
  }  
  data->frameWait.wakeAll();
  for (i = 0; i < data->getThreadCount(); i++) {
    frame.at(i)->wait();
  }
}
