#include <QtGui/QApplication>
#include <QtGui/QMainWindow>
#include <QtGui/QMenuBar>   
#include <QtGui/QMenu>   
#include <QtCore/QString>   
#include <QtCore/QThread>
#include <QtGui/QFileDialog>
#include "data.h"
#include "gui.h"

int main(int argc, char *argv[])  
{

  int threadCount;

  QApplication myApp(argc, argv);
  QMainWindow top;
  top.setWindowTitle("QParallelJulia    (c)2012 by Matthias Nagorni");
  QString qs = QFileDialog::getSaveFileName();
  if (qs.isEmpty()) 
    exit(0); 
  if (argc > 1) {
    threadCount = QString(argv[1]).toInt();
  } else {
    threadCount = QThread::idealThreadCount();
  } 
  Gui *gui = new Gui(qs, threadCount, &top);
  QMenu *fileMenu = top.menuBar()->addMenu("&Datei");
  fileMenu->addAction("&Beenden", &myApp, SLOT(quit()));
  top.setCentralWidget(gui); 
  top.setGeometry(100, 100, 800, 600);
  top.show();
  return myApp.exec(); 
}
