#ifndef GUI_H
#define GUI_H

#include <QtGui/QWidget>
#include <QtGui/QImage>
#include <QtGui/QLabel>
#include <QtCore/QList>
#include <QtCore/QTime>
#include <QtCore/QTimer>
#include "data.h"
#include "view.h"
#include "movie.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    View *view;
    QTime time;
    QTimer *timer;
    QLabel *label;
    Movie *movie;
    int f, w, h, m;
    double x, y, a, b;

  public:
    Gui(QString savePath, int threadCount, QWidget* parent=0);
    ~Gui();
    
  public slots: 
    void movieFinished();
    void updateStatus();
    void updateView();
};

#endif
