#include <QtGui/QVBoxLayout>
#include <QtGui/QScrollArea>
#include <QtCore/QSize>
#include "dialog.h"
#include "gui.h"

Gui::Gui(QString savePath, int threadCount, QWidget *parent) : QWidget(parent) {

  data = new Data(this);
  data->setSavePath(savePath);
  data->setThreadCount(threadCount);
  Dialog *dialog = new Dialog(data, this);
  dialog->exec();
  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  QScrollArea *scroll = new QScrollArea;
  view = new View(data, this);
  view->updateSize();
  scroll->setWidget(view);
  guiLayout->addWidget(scroll);
  data->initChunks();
  timer = new QTimer(this);
  timer->setSingleShot(true);
  timer->setInterval(100);
  QObject::connect(timer, SIGNAL(timeout()), this, SLOT(updateStatus()));
  timer->start();
  time.start();
  movie = new Movie(data);
  QObject::connect(movie, SIGNAL(finished()), this, SLOT(movieFinished()));
  QObject::connect(data, SIGNAL(updateFrame()), this, SLOT(updateView()));
  movie->initMovie();
  movie->start();
  label = new QLabel("Status: Calculating");
  guiLayout->addWidget(label);
}

Gui::~Gui() {

  data->shutdownFlag = true;
  movie->wait();
}

void Gui::movieFinished() {

  view->repaint();
  label->setText("Status: Ready     Time elapsed: " + QString::number(time.elapsed()) + " ms");
}

void Gui::updateStatus() {

   QString status;
   
   status =  QString::number(data->getFrameCount());
   if (data->getFrameCount() < data->getMaxFrames()) {
     label->setText("Status: Computing in " + QString::number(data->getThreadCount()) + " Threads   [" + status +" Frames]");
     timer->start(); 
   } 
}

void Gui::updateView() {

  view->repaint();
}
