#include <math.h>
#include "frame.h"

Frame::Frame(Data *p_data, int p_id, QThread *parent) : QThread(parent) {

  data = p_data;
  id = p_id;
}

int Frame::juliaPixel(double z_re, double z_im, double c_re, double c_im) {

  int iteration;
  long double z_re1, z_re2, z_im1, z_im2, b;
    
  z_re1 = z_re;
  z_im1 = z_im;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < 100.0) && (iteration < data->getMaxIterations())) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }
  return(iteration);
}

void Frame::calcChunk(double c_re, double c_im, int s, int l) {

  int i1, i2, w, h, pixel;
  double z_re, z_im, xOfs, yOfs, xScale, yScale, pScale;
  QRgb colorPixel;

  w = data->getImage()->width();
  h = data->getImage()->height();
  xOfs = -(double)w/2.0;
  yOfs = -(double)h/2.0;
  xScale = zWidth / (double)w;
  yScale = zHeight / (double)h;
  pScale = 1024.0 / (double)data->getMaxIterations();
  for (i1 = 0; i1 < l; i1++) {
    for (i2 = 0; i2 <= w; i2++) {
      z_re = (double)(i2 + xOfs) * xScale;
      z_im = (double)(s + i1 + yOfs) * yScale;
      pixel = juliaPixel(z_re, z_im, c_re, c_im);
      chunkBuf[i1][i2] = pixel;          
    }
  }
  data->frameMutex.lock();
  for (i1 = 0; i1 < l; i1++) {
    for (i2 = 0; i2 <= w; i2++) {
      colorPixel = data->getPalette(pScale * chunkBuf[i1][i2]).rgb();
      if (i2 < w)
        data->getImage()->setPixel(i2, s + i1, colorPixel);
      if (i2 && (s + i1)) 
        data->getImage()->setPixel(w - i2, h - (s + i1), colorPixel);
    }
  }  
  data->frameMutex.unlock();
}

void Frame::run() {

  int i, s, l;
  double c_re, c_im;

  for (i = 0; i < chunkLen; i++) {
    chunkBuf[i] = (int *)malloc((data->getImage()->width() + 1) * sizeof(int));  
  }  
  while(data->getFrameCount() < data->getMaxFrames() && !data->shutdownFlag) {
    data->getC(c_re, c_im);
    while (data->getNextChunk(s, l) && !data->shutdownFlag) {
      calcChunk(c_re, c_im, s, l);
    }
    data->frameMutex.lock();
    data->threadReady();
    if (data->getThreadsReady() == data->getThreadCount()) {    
      data->setThreadsReady(0);
      data->movieWait.wakeOne();   
    }  
    data->frameWait.wait(&data->frameMutex);
    data->frameMutex.unlock();
  } 
  data->frameMutex.lock();
  data->movieWait.wakeOne(); 
  data->frameMutex.unlock();
  for (i = 0; i < chunkLen; i++) {
    free(chunkBuf[i]); 
  }  
}
