#include <QtCore/QStringList>
#include <QtGui/QGridLayout>
#include <QtGui/QPushButton>
#include "data.h"
#include "dialog.h"

Dialog::Dialog(Data *p_data, QWidget *parent) : QDialog(parent) {
  
  int i;
  QStringList movieString, ellipseString;

  data = p_data;
  movieString << "Anzahl Frames: " << "Breite: " << QString::fromUtf8("Höhe: ") << "Iterationen: ";
  ellipseString << "x0: " << "y0: " << QString::fromUtf8("a: ") << "b: ";
  movieInitValue[0] = 101;
  movieInitValue[1] = 1920;
  movieInitValue[2] = 1080;
  movieInitValue[3] = 2000;
  data->setMovie(movieInitValue[0], movieInitValue[1], movieInitValue[2], movieInitValue[3]);
  ellipseInitValue[0] = 0.4;
  ellipseInitValue[1] = 0.16;
  ellipseInitValue[2] = 0.02;
  ellipseInitValue[3] = 0.05;
  data->setEllipse(ellipseInitValue[0], ellipseInitValue[1], ellipseInitValue[2], ellipseInitValue[3]);
  QGridLayout *mainLayout = new QGridLayout;
  setLayout(mainLayout);
  mainLayout->addWidget(new QLabel("Filmsequenz:"), 0, 0);
  mainLayout->addWidget(new QLabel("Ellipse:"), 0, 3);
  for (i = 0; i < 4; i++) {
    movieLabel[i] = new QLabel(movieString.at(i));
    mainLayout->addWidget(movieLabel[i], i + 1, 0);
    movieParam[i] = new QSpinBox;
    movieParam[i]->setMinimum(1);
    movieParam[i]->setMaximum(10000);
    movieParam[i]->setValue(movieInitValue[i]);
    mainLayout->addWidget(movieParam[i], i + 1, 1);    
    mainLayout->setColumnMinimumWidth(2, 50);
    ellipseLabel[i] = new QLabel(ellipseString.at(i));
    mainLayout->addWidget(ellipseLabel[i], i + 1, 3);
    ellipseParam[i] = new QDoubleSpinBox;
    if (i < 2) {
      ellipseParam[i]->setMinimum(-10);
      ellipseParam[i]->setMaximum(10);
    } else {
      ellipseParam[i]->setMinimum(0);
      ellipseParam[i]->setMaximum(10);
    }  
    ellipseParam[i]->setDecimals(5);
    ellipseParam[i]->setSingleStep(0.01);
    ellipseParam[i]->setValue(ellipseInitValue[i]);
    mainLayout->addWidget(ellipseParam[i], i + 1, 4);    
  }
  QPushButton *okButton = new QPushButton("OK");
  mainLayout->setRowMinimumHeight(5, 20);
  mainLayout->addWidget(okButton, 6, 2);
  QObject::connect(okButton, SIGNAL(clicked()), this, SLOT(dialogOK()));
}

void Dialog::dialogOK() {
  
  data->setMovie(movieParam[0]->value(), movieParam[1]->value(), movieParam[2]->value(), movieParam[3]->value());
  data->setEllipse(ellipseParam[0]->value(), ellipseParam[1]->value(), ellipseParam[2]->value(), ellipseParam[3]->value());
  done(0);
}
