#include <math.h>
#include "data.h"

Data::Data(QObject *parent) : QObject(parent) {

  threadCount = 1;
  threadsReady = 0;
  chunkCount = 0;
  frameCount = 0;
  shutdownFlag = false;
}

QImage * Data::getImage() {

  return(image);
}

QSize Data::getImageSize() {

  return(image->size());
}

void Data::initPalette() {

  int i;
  
  for (i = 0; i < 16; i++) 
    palette[i] = QColor(0, 8 * i, 16 * i);    
  for (i = 16; i < 32; i++) 
    palette[i] = QColor(0, 8 * i, 383 - 8 * i);    
  for (i = 32; i < 64; i++) 
    palette[i] = QColor(8 * (i - 32), 255, 256 - 4 * i);    
  for (i = 64; i < 128; i++) 
    palette[i] = QColor(511 - 4 * i, 255, 4 * (i - 64));    
  for (i = 128; i < 256; i++) 
    palette[i] = QColor(0, 255, 383 - i);    
  for (i = 256; i < 384; i++) 
    palette[i] = QColor(i - 256, 511 - i, 383 - i);    
  for (i = 384; i < 512; i++) 
    palette[i] = QColor(128, 128, i - 384);    
  for (i = 512; i < 1024; i++) 
    palette[i] = QColor(i / 4, i / 4, i / 4);    
}

QColor Data::getPalette(int paletteIndex) {

  return(palette[paletteIndex]);
}

void Data::setThreadCount(int value) {

  threadCount = value;
}

int Data::getThreadCount() {

  return(threadCount);
}

void Data::setThreadsReady(int value) {

  threadsReady = value;
}

int Data::getThreadsReady() {

  return(threadsReady);
}

void Data::threadReady() {

  threadsReady++;
}

void Data::frameReady() {

  emit updateFrame();
}

void Data::initChunks() { 

  chunkCount = (int)ceil((double)(imageHeight / 2) / (double)chunkLen);
}

int Data::getChunkCount() {

  return(chunkCount);
}

bool Data::getNextChunk(int &start, int &len) { 

  bool ok;
  
  chunkMutex.lock();
  chunkCount--;
  start = chunkCount * chunkLen;
  len = (start > (imageHeight - chunkLen)) ? imageHeight - start : chunkLen;
  ok = start >= 0;
  chunkMutex.unlock();
  return(ok);
}

int Data::getFrameCount() {

  return(frameCount);
}

void Data::nextFrame() {

  initChunks();
  frameCount++;
  c_re = c_x + c_a * cos((double)frameCount * 6.283185 / (double)maxFrames);
  c_im = c_y + c_b * sin((double)frameCount * 6.283185 / (double)maxFrames);
}

void Data::setMovie(int p_maxFrames, int p_imageWidth, int p_imageHeight, int p_maxIterations) {

  maxFrames = p_maxFrames;
  imageWidth = p_imageWidth;
  imageHeight = p_imageHeight;
  maxIterations = p_maxIterations;
  image = new QImage(imageWidth, imageHeight, QImage::Format_RGB32);
  image->fill(0xA0A0A0);
  initPalette();
}

void Data::setEllipse(double p_c_x, double p_c_y, double p_c_a, double p_c_b) {

  c_x = p_c_x;
  c_y = p_c_y;
  c_a = p_c_a;
  c_b = p_c_b;
  c_re = c_x + c_a;
  c_im = c_y;
}

void Data::getC(double &p_c_re, double &p_c_im) {

  p_c_re = c_re;
  p_c_im = c_im;
}

int Data::getMaxIterations() {

  return(maxIterations);
}

int Data::getMaxFrames() {

  return(maxFrames);
}

void Data::setSavePath(QString qs) {

  savePath = qs;
}

void Data::saveFrame() {
  
  QString qs1, qs2;

  qs1 = QString::number(frameCount);
  qs2 = QString::number(maxFrames);
  while (qs1.length() < qs2.length()) {
    qs1 = "0" + qs1;
  } 
  image->save(savePath + qs1 + ".png");
}
