#include <QtGui/QVBoxLayout>
#include <QtGui/QPushButton>
#include <QtCore/QString>
#include "gui.h"

Gui::Gui(QWidget *parent) : QWidget(parent) {

  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  for (int i = 0; i < THREADS; i++) {
    calc[i] = new Calc(i, 1e9 + 1e8 * i);
    QObject::connect(calc[i], SIGNAL(finished()), this, SLOT(calcFinished()));
    label[i] = new QLabel("Berechne kleinste Primzahl > " + 
                          QString::number(calc[i]->startValue));
    guiLayout->addWidget(label[i]);
  }  
  QPushButton *button = new QPushButton("Start");
  guiLayout->addWidget(button);
  QObject::connect(button, SIGNAL(clicked()), this, SLOT(doCalc()));
}

void Gui::doCalc() {

  bool threadRunning = false;
  for (int i = 0; i < THREADS; i++) 
    if (calc[i]->isRunning()) threadRunning = true;
  if (!threadRunning) {
    for (int i = 0; i < THREADS; i++) {
      label[i]->setText(QString::fromUtf8("Berechnung läuft..."));
      calc[i]->start();
    }  
  }  
}

void Gui::calcFinished() {

  int id = ((Calc *)sender())->id;
  label[id]->setText("Kleinste Primzahl > " + 
                     QString::number(calc[id]->startValue) + 
                     " = " + QString::number(calc[id]->primzahl));
}
