#include <QtGui/QVBoxLayout>
#include <QtGui/QPushButton>
#include <QtCore/QString>
#include "gui.h"

Gui::Gui(QWidget *parent) : QWidget(parent) {

  QVBoxLayout *guiLayout = new QVBoxLayout;
  setLayout(guiLayout);
  label = new QLabel("Berechne kleinste Primzahl > 1e9");
  guiLayout->addWidget(label);
  QPushButton *button = new QPushButton("Start");
  guiLayout->addWidget(button);
  QObject::connect(button, SIGNAL(clicked()), this, SLOT(calc()));
}

void Gui::calc() {

  long long l1 = 1e9;
  do {
    primzahl = l1;
    for (long long l2 = 2; l2 < l1>>1; l2++) {
      if (!(l1 % l2)) {
        primzahl = 0;
        l1++;
        break;
      }
    }
  } while (!primzahl);
  label->setText("Kleinste Primzahl > 1e9 = " + QString::number(primzahl));
}
