#ifndef XMLHANDLER_H
#define XMLHANDLER_H

#include <QtCore/QObject>
#include <QtXml/QXmlDefaultHandler>
#include <QtGui/QColor>
#include "data.h"

class XmlHandler : public QXmlDefaultHandler
{
  private:
    Data *data;
    int index, nextCode, xmlData[6];
    long double doubleData[6];
    bool palettePointFlag, paramFlag;
    
  public:
    XmlHandler(Data *p_data, int index);
    ~XmlHandler();
    bool startDocument();
    bool endDocument();
    bool startElement(const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &atts);
    bool endElement(const QString &namespaceURI, const QString &localName, const QString &qName);
    bool characters(const QString &ch);
};
  
#endif
