#include <QtXml/QXmlContentHandler>
#include "data.h"
#include "xmlhandler.h"

XmlHandler::XmlHandler(Data *p_data, int p_index) : QXmlDefaultHandler() {

  int i;
  
  data = p_data;
  index = p_index;
  nextCode = 0;
  for (i = 0; i < 4; i++) {
    xmlData[i] = 0;
  }
  paramFlag = false;
  palettePointFlag = false;
}

XmlHandler::~XmlHandler() {

}

bool XmlHandler::startDocument() {

  return(true);
}

bool XmlHandler::endDocument() {

  return(true);
}

bool XmlHandler::startElement(const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &atts) {

  if (qName.compare("Parameters") == 0) {
    paramFlag = true;
    nextCode = 0;
  }
  if (qName.compare("PalettePoint") == 0) {
    palettePointFlag = true;
    nextCode = 0;
  }
  if (qName.compare("MandelPalette") == 0) {
    index = 0;
  }
  if (qName.compare("JuliaPalette") == 0) {
    index = 1;
  }
  if (paramFlag) {
    if (qName.compare("MandelZoom") == 0) {
     nextCode = 1;
    }
    if (qName.compare("JuliaZoom") == 0) {
     nextCode = 2;
    }
    if (qName.compare("C_Re") == 0) {
     nextCode = 3;
    }
    if (qName.compare("C_Im") == 0) {
     nextCode = 4;
    }
    if (qName.compare("MandelXOfs") == 0) {
     nextCode = 5;
    }
    if (qName.compare("MandelYOfs") == 0) {
     nextCode = 6;
    }
    if (qName.compare("JuliaXOfs") == 0) {
     nextCode = 7;
    }
    if (qName.compare("JuliaYOfs") == 0) {
     nextCode = 8;
    }
    if (qName.compare("MandelIterations") == 0) {
     nextCode = 9;
    }
    if (qName.compare("JuliaIterations") == 0) {
     nextCode = 10;
    }
    if (qName.compare("MandelMaxAbsoluteValue") == 0) {
     nextCode = 11;
    }
    if (qName.compare("JuliaMaxAbsoluteValue") == 0) {
     nextCode = 12;
    }
  }
  if (palettePointFlag) {  
    if (qName.compare("Pos") == 0) {
      nextCode = 1;
    }
    if (qName.compare("Red") == 0) {
      nextCode = 2;
    }
    if (qName.compare("Green") == 0) {
      nextCode = 3;
    }
    if (qName.compare("Blue") == 0) {
      nextCode = 4;
    }
  }  
  return(true);
}

bool XmlHandler::endElement(const QString &namespaceURI, const QString &localName, const QString &qName) {

  int i, colorIndex, pos;
  QColor color;

  if (paramFlag && (qName.compare("Parameters") == 0)) {
    paramFlag = false;
    data->setMandelZoomRaw(doubleData[0]);
    data->setJuliaZoomRaw(doubleData[1]);
    data->setC(doubleData[2], doubleData[3]);
    for (i = 0; i < 2; i++) {
      data->setOfs(i, xmlData[2 * i], xmlData[2 * i + 1]);
    }  
    data->setMaxIterations(0, xmlData[4]);
    data->setMaxIterations(1, xmlData[5]);
    data->setMaxAbsoluteValue(0, doubleData[4]);
    data->setMaxAbsoluteValue(1, doubleData[5]);
  }
  if (palettePointFlag && (qName.compare("PalettePoint") == 0)) {
    palettePointFlag = false;
    pos = xmlData[0];
    color = QColor(xmlData[1], xmlData[2], xmlData[3]);
    data->addColor(index, pos, color, colorIndex);
  }
  return(true);
}

bool XmlHandler::characters(const QString &ch) {

  if (paramFlag && !ch.trimmed().isEmpty()) {
    if (nextCode < 5) {
      doubleData[nextCode - 1] = ch.toDouble();
    } else {
      if (nextCode < 11) {
        xmlData[nextCode - 5] = ch.toInt();
      } else {
        doubleData[nextCode - 7] = ch.toDouble();
      }  
    }  
  }  
  if (palettePointFlag && !ch.trimmed().isEmpty()) {
    xmlData[nextCode - 1] = ch.toInt();
  }  
  return(true);
}
