#ifndef MANDELVIEW_H
#define MANDELVIEW_H

#include <math.h>
#include <QtGui/QWidget>
#include <QtGui/QMouseEvent>
#include <QtCore/QString>
#include <QtCore/QPoint>
#include "data.h"

class MandelView : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    QPoint mousePos;
    bool mousePressed, juliaTracking;
    int *mandelDataCache;

  public:
    MandelView(Data *p_data, QWidget* parent=0, int w=300, int h=200);
    ~MandelView();

  protected:
    virtual void paintEvent(QPaintEvent *);
    virtual void mousePressEvent (QMouseEvent* );
    virtual void mouseReleaseEvent (QMouseEvent* );
    virtual void mouseMoveEvent (QMouseEvent* );
    virtual void mouseDoubleClickEvent (QMouseEvent *ev);

  signals:
    void imageMoved(QPoint dp);
    void newJuliaC();
  
  public slots: 
    void moveImage (QPoint dp); 
    void changeColor();
};
  
#endif
