#ifndef MANDELCALC_H
#define MANDELCALC_H

#include <math.h>
#include <QtCore/QThread>
#include "data.h"

class MandelCalc : public QThread
{
  Q_OBJECT

  private:
    Data *data;
    int tileBuf[TILE_LEN][TILE_LEN];

  public:
    int id;
    
  protected:
    virtual void run();
    
  public:
    MandelCalc(Data *p_data, int p_id, QThread *parent=0);
    ~MandelCalc();
    int mandelPixel(long double c_re, long double c_im, long double max);
};
  
#endif
