#include <math.h>
#include <QtCore/QObject>
#include "data.h"
#include "juliacalc.h"

JuliaCalc::JuliaCalc(Data *p_data, int p_id, QThread *parent) : QThread(parent) {

  data = p_data;
  id = p_id;
}

int JuliaCalc::juliaPixel(long double z_re, long double z_im, long double c_re, long double c_im, long double max) {

  int iteration;
  long double z_re1, z_re2, z_im1, z_im2, b;
  
  z_re1 = z_re;
  z_im1 = z_im;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < max) && (iteration < data->getMaxIterations(1))) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2.0 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }   
  return(iteration);
}

JuliaCalc::~JuliaCalc() {

}

void JuliaCalc::run() {

  int i1, i2, d, s, w;
  QPoint tile;
  int pixel, xOfs, yOfs;
  long double c_re, c_im, z_re, z_im, max; 
  long double xScale, yScale, pScale;
  QRgb colorPixel;
  
  data->getC(c_re, c_im); 
  data->getOfs(1, xOfs, yOfs);
  data->getScale(1, xScale, yScale);
  max = data->getMaxAbsoluteValue(1);
  while (data->getNextTile(1, tile) && !data->shutdownFlag) {
    for (d = TILE_LEN; d > 0; d--) {
      for (s = 0; s < d; s++) {
        z_re = (long double)(s + tile.x() + xOfs) * xScale;
        z_im = (long double)(tile.y() + yOfs) * yScale;
        pixel = juliaPixel(z_re, z_im, c_re, c_im, max);
        tileBuf[s][s] = pixel;
        z_re = (long double)(s + tile.x() + xOfs) * xScale;
        z_im = (long double)(d - 1 + tile.y() + yOfs) * yScale;
        pixel = juliaPixel(z_re, z_im, c_re, c_im, max);
        tileBuf[s][d-1] = pixel;
        z_re = (long double)(tile.x() + xOfs) * xScale;
        z_im = (long double)(s + tile.y() + yOfs) * yScale;
        pixel = juliaPixel(z_re, z_im, c_re, c_im, max);
        tileBuf[0][s] = pixel;
        z_re = (long double)(d - 1 + tile.x() + xOfs) * xScale;
        z_im = (long double)(s + tile.y() + yOfs) * yScale;
        pixel = juliaPixel(z_re, z_im, c_re, c_im, max);
        tileBuf[d-1][s] = pixel;          
      }
    }
    data->juliaMutex.lock();
    w = data->getImageWidth();
    pScale = (data->getNormalize()) ? (long double)data->getMaxIterations(1) / (long double)data->getMax(1) : 1.0;
    for (i1 = 0; i1 < TILE_LEN; i1++) {
      for (i2 = 0; i2 < TILE_LEN; i2++) {
        data->juliaData[(i1 + tile.x())  + (i2 + tile.y()) * w] = tileBuf[i1][i2]; 
        colorPixel = data->getPalette(1, (int)(pScale * (long double)tileBuf[i1][i2])).rgb();
        data->juliaImage->setPixel(i1 + tile.x(), i2 + tile.y(), colorPixel);
      }  
    }
    data->juliaMutex.unlock();
  }    
}
