#ifndef ITERATIONDIALOG_H
#define ITERATIONDIALOG_H

#include <QtGui/QWidget>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QSpinBox>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QCheckBox>
#include <QtGui/QGroupBox>
#include <QtGui/QRadioButton>
#include <QtGui/QLineEdit>
#include "data.h"

class IterationDialog : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    QPushButton *closeButton;
    QSpinBox *mandelIterationSpin, *juliaIterationSpin;
    QLineEdit *mandelMaxEdit, *juliaMaxEdit;
    QCheckBox *rescaleCheck, *normalizeCheck;
    QGroupBox *aliasingGroup;
    QRadioButton *aliasingButton[4];

  public:
    IterationDialog(Data *p_data, QWidget* parent=0, Qt::WindowFlags f=0);
    ~IterationDialog();
    void setMaxIterations(int index, int value);
    void setMaxAbsoluteValue(int index, double value);

  signals:
    void mandelIterationChanged();
    void juliaIterationChanged(); 
    void normalizeChanged();

  public slots: 
    void setMandelIterations(int value);
    void setJuliaIterations(int value);
    void setMandelMax(QString qs);
    void setJuliaMax(QString qs);
    void rescaleToggled(bool on);
    void normalizeToggled(bool on);
    void setAntiAliasing(bool on);
};

#endif
