#include <limits>
#include <QtGui/QSlider>
#include <QtGui/QDoubleValidator>
#include "data.h"
#include "iterationdialog.h"

IterationDialog::IterationDialog(Data *p_data, QWidget *parent, Qt::WindowFlags f) : QWidget(parent, f) {

  int i;

  data = p_data;
  QVBoxLayout *mainLayout = new QVBoxLayout;
  mainLayout->addWidget(new QLabel("Max. Iterations for Mandelbrot Set"));
  mandelIterationSpin = new QSpinBox();
  mandelIterationSpin->setMinimum(100);
  mandelIterationSpin->setMaximum(MAX_ITERATIONS - 1);
  mandelIterationSpin->setKeyboardTracking(false);
  mandelIterationSpin->setValue(data->getMaxIterations(0));
  mainLayout->addWidget(mandelIterationSpin);
  QObject::connect(mandelIterationSpin, SIGNAL(valueChanged(int)), this, SLOT(setMandelIterations(int)));
  mainLayout->addWidget(new QLabel("Max. Iterations for Julia Set"));
  juliaIterationSpin = new QSpinBox();
  juliaIterationSpin->setMinimum(100);
  juliaIterationSpin->setMaximum(MAX_ITERATIONS - 1);
  juliaIterationSpin->setKeyboardTracking(false);
  juliaIterationSpin->setValue(data->getMaxIterations(1));
  mainLayout->addWidget(juliaIterationSpin);
  QObject::connect(juliaIterationSpin, SIGNAL(valueChanged(int)), this, SLOT(setJuliaIterations(int)));
  mainLayout->addWidget(new QLabel("Max. Absolute Value for Mandelbrot Set"));
  mandelMaxEdit = new QLineEdit();
  QDoubleValidator *validator = new QDoubleValidator;
  mandelMaxEdit->setValidator(validator);
  validator->setBottom(0);
  mandelMaxEdit->setText(QString::number(data->getMaxAbsoluteValue(0)));
  mainLayout->addWidget(mandelMaxEdit);
  QObject::connect(mandelMaxEdit, SIGNAL(textChanged(QString)), this, SLOT(setMandelMax(QString)));
  mainLayout->addWidget(new QLabel("Max. Absolute Value for Julia Set"));
  juliaMaxEdit = new QLineEdit();
  juliaMaxEdit->setValidator(validator);
  juliaMaxEdit->setText(QString::number(data->getMaxAbsoluteValue(1)));
  mainLayout->addWidget(juliaMaxEdit);
  QObject::connect(juliaMaxEdit, SIGNAL(textChanged(QString)), this, SLOT(setJuliaMax(QString)));
  QHBoxLayout *checkBoxLayout = new QHBoxLayout;
  QWidget *checkBoxFrame = new QWidget;    
  checkBoxFrame->setLayout(checkBoxLayout);  
  rescaleCheck = new QCheckBox("Rescale Palette");
  QObject::connect(rescaleCheck, SIGNAL(toggled(bool)), this, SLOT(rescaleToggled(bool)));
  checkBoxLayout->addWidget(rescaleCheck);
  normalizeCheck = new QCheckBox("Normalize");
  QObject::connect(normalizeCheck, SIGNAL(toggled(bool)), this, SLOT(normalizeToggled(bool)));
  checkBoxLayout->addWidget(normalizeCheck);
  mainLayout->addWidget(checkBoxFrame);

  QVBoxLayout *aliasingLayout = new QVBoxLayout;
  aliasingGroup = new QGroupBox("Anti-Aliasing for High Resolution");
  aliasingButton[0] = new QRadioButton("None");
  aliasingButton[1] = new QRadioButton("Fast");
  aliasingButton[2] = new QRadioButton("Medium");
  aliasingButton[3] = new QRadioButton("High Quality");
  for (i = 0; i < 4; i++) {
    aliasingLayout->addWidget(aliasingButton[i]);
    QObject::connect(aliasingButton[i], SIGNAL(toggled(bool)), this, SLOT(setAntiAliasing(bool)));
  }  
  aliasingButton[3]->setChecked(true);
  aliasingGroup->setLayout(aliasingLayout);
  mainLayout->addWidget(aliasingGroup);

  QHBoxLayout *buttonLayout = new QHBoxLayout;
  QWidget *buttonFrame = new QWidget;
  buttonFrame->setLayout(buttonLayout);
  closeButton = new QPushButton("Close");
  QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(hide()));
  buttonLayout->addWidget(new QWidget);
  buttonLayout->addWidget(closeButton);
  buttonLayout->addWidget(new QWidget);
  mainLayout->addWidget(buttonFrame);

  setLayout(mainLayout);
}

IterationDialog::~IterationDialog() {

}

void IterationDialog::setMandelIterations(int value) {

  data->setMaxIterations(0, value);
  emit mandelIterationChanged();  
}

void IterationDialog::setJuliaIterations(int value) {

  data->setMaxIterations(1, value);
  emit juliaIterationChanged();  
}

void IterationDialog::setMandelMax(QString qs) {

  data->setMaxAbsoluteValue(0, qs.toDouble());
  emit mandelIterationChanged();
}

void IterationDialog::setJuliaMax(QString qs) {

  data->setMaxAbsoluteValue(1, qs.toDouble());
  emit juliaIterationChanged();
}

void IterationDialog::rescaleToggled(bool on) {

  data->setRescalePalette(on);
}

void IterationDialog::normalizeToggled(bool on) {

  data->setNormalize(on);
  emit normalizeChanged();
}

void IterationDialog::setMaxIterations(int index, int value) {

  if (index) {
    juliaIterationSpin->setValue(value);
  } else {
    mandelIterationSpin->setValue(value);
  }
}

void IterationDialog::setMaxAbsoluteValue(int index, double value) {

  if (index) {
    juliaMaxEdit->setText(QString::number(value));
  } else {
    mandelMaxEdit->setText(QString::number(value));
  }
}

void IterationDialog::setAntiAliasing(bool on) {

  int i;
  
  for (i = 0; i < 4; i++) {
    if ((aliasingButton[i] == sender()) && on) {
      data->setAntiAliasing(i);
      break;
    }
  }
}
