#include <math.h>
#include <QtGui/QPainter>
#include "data.h"
#include "hiresview.h"

HiresView::HiresView(Data *p_data, QWidget *parent, int w, int h) : QWidget(parent) {

  data = p_data;
  setMinimumSize(w, h);
}

HiresView::~HiresView() {

}

void HiresView::paintEvent(QPaintEvent *) {

  QPainter p;
  
  p.begin(this);
  p.drawImage(0, 0, *data->hiresImage);
  p.end();
}

void HiresView::mousePressEvent (QMouseEvent *ev) {

  if (ev->button() == Qt::LeftButton) {
    mousePos = ev->pos();
    mousePressed = true;
  }  
}

void HiresView::mouseReleaseEvent (QMouseEvent *ev) {

  if (ev->button() == Qt::LeftButton) {
    mousePressed = false;
  }  
}

void HiresView::mouseMoveEvent (QMouseEvent *ev) {

  if (mousePressed) {
    emit moveView(mousePos - ev->pos());   
    mousePos = ev->pos();
  }  
}


void HiresView::changeColor() {

}
