#ifndef HIRESCALC_H
#define HIRESCALC_H

#include <math.h>
#include <QtCore/QThread>
#include "data.h"

class HiresCalc : public QThread
{
  Q_OBJECT

  private:
    Data *data;
    int *chunkBuf[CHUNK_LEN];

  public:
    int id;

  protected:
    virtual void run();

  public:
    HiresCalc(Data *p_data, int p_id, QThread *parent=0);
    ~HiresCalc();
    int juliaPixel(long double z_re, long double z_im, long double c_re, long double c_im, long double max);
    int mandelPixel(long double z_re, long double z_im, long double max);
};
  
#endif
