#include <math.h>
#include <QtCore/QObject>
#include "data.h"
#include "hirescalc.h"

HiresCalc::HiresCalc(Data *p_data, int p_id, QThread *parent) : QThread(parent) {

  data = p_data;
  id = p_id;
}

int HiresCalc::mandelPixel(long double c_re, long double c_im, long double max) {

  int iteration;
  long double z_re1, z_re2, z_im1, z_im2, b;
  
  z_re1 = 0;
  z_im1 = 0;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < max) && (iteration < data->getMaxIterations(0))) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2.0 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }   
  return(iteration);
}

int HiresCalc::juliaPixel(long double z_re, long double z_im, long double c_re, long double c_im, long double max) {

  int iteration;
  long double z_re1, z_re2, z_im1, z_im2, b;
  
  z_re1 = z_re;
  z_im1 = z_im;
  z_re2 = 0;
  z_im2 = 0;
  b = 0;
  iteration = 0;
  while ((b < max) && (iteration < data->getMaxIterations(1))) {
    z_re2 = z_re1 * z_re1 - z_im1 * z_im1 + c_re;
    z_im2 = 2.0 * z_re1 * z_im1 + c_im;
    b = z_re2 * z_re2 + z_im2 * z_im2;
    z_re1 = z_re2;
    z_im1 = z_im2;
    iteration++;
  }   
  return(iteration);
}

HiresCalc::~HiresCalc() {

}

void HiresCalc::run() {

  int i1, i2, s, w, l;
  int pixel, maxChunkLen;
  long double c_re, c_im, z_re, z_im, max, pScale, xScale, yScale, xOfs, yOfs, xs, ys;
  QRgb colorPixel;

  maxChunkLen = data->getChunkLen();
  for (i1 = 0; i1 < maxChunkLen; i1++) {
    chunkBuf[i1] = (int *)malloc(data->getHiresWidth() * sizeof(int));  
  }  
  w = data->getHiresWidth();
  pixel = 0;
  if (data->hiresJulia()) {  
    data->getC(c_re, c_im); 
    max = data->getMaxAbsoluteValue(1);
    xScale = ((long double)data->getImageWidth() / (long double)data->getHiresWidth()) * data->getXScale(1);
    yScale = ((long double)data->getImageHeight() / (long double)data->getHiresHeight()) * data->getYScale(1);
    xOfs = ((long double)data->getHiresWidth() / (long double)data->getImageWidth()) * data->getXOfs(1);
    yOfs = ((long double)data->getHiresHeight() / (long double)data->getImageHeight()) * data->getYOfs(1);
    xs = xScale / 2.0;
    ys = yScale / 2.0;
    while (data->getNextChunk(s, l) && !data->shutdownFlag) {
      for (i1 = 0; i1 < l; i1++) {
        for (i2 = 0; i2 < w; i2++) {
          z_re = (long double)(i2 + xOfs) * xScale;
          z_im = (long double)(s + i1 + yOfs) * yScale;
          switch (data->getAntiAliasing()) {
          case 0:
            pixel = juliaPixel(z_re, z_im, c_re, c_im, max);
            break;
          case 1:
            pixel = (int)(0.5 * (long double)(juliaPixel(z_re + xs, z_im, c_re, c_im, max) + juliaPixel(z_re - xs, z_im, c_re, c_im, max)));  
            break;
          case 2:
            pixel = (int)((long double)(juliaPixel(z_re + xs, z_im, c_re, c_im, max) + juliaPixel(z_re - xs, z_im, c_re, c_im, max) +
                                        juliaPixel(z_re, z_im - ys, c_re, c_im, max) + juliaPixel(z_re, z_im + ys, c_re, c_im, max) +
                                        2 * juliaPixel(z_re, z_im, c_re, c_im, max)) / 6.0);
            break;
          case 3:
            pixel = (int)((long double)(2 * juliaPixel(z_re + xs, z_im, c_re, c_im, max) + 2 * juliaPixel(z_re - xs, z_im, c_re, c_im, max) +
                                        2 * juliaPixel(z_re, z_im - ys, c_re, c_im, max) + 2 * juliaPixel(z_re, z_im + ys, c_re, c_im, max) +
                                        juliaPixel(z_re - xs, z_im - ys, c_re, c_im, max) + juliaPixel(z_re - xs, z_im + ys, c_re, c_im, max) +
                                        juliaPixel(z_re + xs, z_im - ys, c_re, c_im, max) + juliaPixel(z_re + xs, z_im + ys, c_re, c_im, max) +
                                        4 * juliaPixel(z_re, z_im, c_re, c_im, max)) / 16.0);
            break;
          }  
          chunkBuf[i1][i2] = pixel;          
        }
      }
      data->hiresMutex.lock();
      pScale = (data->getNormalize()) ? (long double)data->getMaxIterations(1) / (long double)data->getMax(1) : 1.0;
      for (i1 = 0; i1 < l; i1++) {
        for (i2 = 0; i2 < w; i2++) {
          colorPixel = data->getPalette(1, (int)(pScale * (long double)chunkBuf[i1][i2])).rgb();
          data->hiresImage->setPixel(i2, s + i1, colorPixel);
        }  
      }
      data->hiresMutex.unlock();
    }
  } else {
    max = data->getMaxAbsoluteValue(0);
    xScale = ((long double)data->getImageWidth() / (long double)data->getHiresWidth()) * data->getXScale(0);
    yScale = ((long double)data->getImageHeight() / (long double)data->getHiresHeight()) * data->getYScale(0);
    xOfs = ((long double)data->getHiresWidth() / (long double)data->getImageWidth()) * data->getXOfs(0);
    yOfs = ((long double)data->getHiresHeight() / (long double)data->getImageHeight()) * data->getYOfs(0);
    xs = xScale / 2.0;
    ys = yScale / 2.0;
    while (data->getNextChunk(s, l) && !data->shutdownFlag) {
      for (i1 = 0; i1 < l; i1++) {
        for (i2 = 0; i2 < w; i2++) {
          z_re = (long double)(i2 + xOfs) * xScale;
          z_im = (long double)(s + i1 + yOfs) * yScale;
          switch (data->getAntiAliasing()) {
          case 0:
            pixel = mandelPixel(z_re, z_im, max);
            break;
          case 1:
            pixel = (int)(0.5 * (long double)(mandelPixel(z_re + xs, z_im, max) + mandelPixel(z_re - xs, z_im, max)));  
            break;
          case 2:
            pixel = (int)((long double)(mandelPixel(z_re + xs, z_im, max) + mandelPixel(z_re - xs, z_im, max) +
                                        mandelPixel(z_re, z_im - ys, max) + mandelPixel(z_re, z_im + ys, max) +
                                        2 * mandelPixel(z_re, z_im, max)) / 6.0);
            break;
          case 3:
            pixel = (int)((long double)(2 * mandelPixel(z_re + xs, z_im, max) + 2 * mandelPixel(z_re - xs, z_im, max) +
                                        2 * mandelPixel(z_re, z_im - ys, max) + 2 * mandelPixel(z_re, z_im + ys, max) +
                                        mandelPixel(z_re - xs, z_im - ys, max) + mandelPixel(z_re - xs, z_im + ys, max) +
                                        mandelPixel(z_re + xs, z_im - ys, max) + mandelPixel(z_re + xs, z_im + ys, max) +
                                        4 * mandelPixel(z_re, z_im, max)) / 16.0);
            break;
          }  
          chunkBuf[i1][i2] = pixel;          
        }
      }
      data->hiresMutex.lock();
      pScale = (data->getNormalize()) ? (long double)data->getMaxIterations(0) / (long double)data->getMax(0) : 1.0;
      for (i1 = 0; i1 < l; i1++) {
        for (i2 = 0; i2 < w; i2++) {
          colorPixel = data->getPalette(0, (int)(pScale * (long double)chunkBuf[i1][i2])).rgb();
          data->hiresImage->setPixel(i2, s + i1, colorPixel);
        }  
      }
      data->hiresMutex.unlock();
    }
  }
  for (i1 = 0; i1 < maxChunkLen; i1++) {
    free(chunkBuf[i1]); 
  }  
}
