#ifndef DATA_H
#define DATA_H

#include <QtCore/QObject>
#include <QtCore/QMutex>
#include <QtCore/QThread>
#include <QtCore/QPoint>
#include <QtGui/QColor>
#include <QtCore/QWaitCondition>
#include <QtCore/QFile>
#include <QtGui/QImage>

#define WIDTH 640
#define HEIGHT 480
#define TILE_LEN 20
#define CHUNK_LEN 40
#define MAX_HIRES_WIDTH 32768
#define MAX_HIRES_HEIGHT 16384
#define MAX_ITERATIONS 10001
#define MAX_COLOR 64

typedef struct paletteColorType {
  QColor color;
  int pos;
} paletteColorType;

class Data : public QObject
{
  private:
     long double mandelZoom, juliaZoom;
     int imageWidth, imageHeight;
     int hiresWidth, hiresHeight;
     int chunkCount, chunkLen;
     long double xOfs[2], yOfs[2];
     long double xScale[2], yScale[2];
     long double c_re, c_im;
     int maxIterations[2], max[2];
     double maxAbsoluteValue[2];
     QPoint *tiles[2];
     int tileCount[2];
     paletteColorType color[2][MAX_COLOR];
     QColor palette[2][MAX_ITERATIONS];
     double paletteScale[2];
     int colorCount[2];
     bool hiresJuliaFlag, rescalePalette, normalize;
     int antiAliasing;
     int threadCount, threadsReady[3];
     bool imageBusyFlag[3];
    
  public:
    QMutex tileMutex[2], chunkMutex, mandelMutex, juliaMutex, hiresMutex;
    QImage *mandelImage, *juliaImage, *hiresImage;
    int *mandelData, *juliaData;
    bool showZoomRect[2];
    long double tmpZoom[2];
    bool shutdownFlag;
    
  public:
    Data(QObject* parent=0);
    ~Data();
    void setThreadCount(int value);
    int getThreadCount();
    int getThreadsReady(int index);
    void threadReady(int index);
    void imageBusy(int index);
    bool getImageBusy(int index);
    void imageReady(int index);
    void calcTiles(int index, int dx, int dy);
    void calcTiles(int index);
    int getTileCount(int index);
    bool getNextTile(int index, QPoint &tile);
    void calcChunks(int len);
    int getChunkCount();
    int getChunkLen();
    bool getNextChunk(int &pos, int &len);
    void setHiresWidth(int value);
    int getHiresWidth();
    void setHiresHeight(int value);
    int getHiresHeight();
    void setHiresJulia(bool value);
    bool hiresJulia();
    void setMandelZoomRaw(long double value);
    void setJuliaZoomRaw(long double value);
    void setMandelZoom(long double value);
    long double getMandelZoom();
    void setJuliaZoom(long double value);
    long double getJuliaZoom();
    void setImageWidth(int value);
    int getImageWidth();
    void setImageHeight(int value);
    int getImageHeight();
    void getScale(int index, long double &x, long double &y);
    void setOfs(int index, int x, int y);
    void getOfs(int index, int &x, int &y);
    void moveOfs(int index, QPoint dp);
    long double getXScale(int index);
    long double getYScale(int index);
    int getXOfs(int index);
    int getYOfs(int index);
    void initImages();
    void setC(long double p_c_re, long double p_c_im);
    void getC(long double &p_c_re, long double &p_c_im);
    void clearPalette(int index);
    void addColor(int index, int pos, QColor p_color, int &colorIndex);
    void delColor(int index, int colorIndex);
    void setColor(int index, int colorIndex, QColor p_color);
    QColor getColor(int index, int colorIndex, int &pos);
    void setColorPos(int index, int colorIndex, int pos);
    int getColorPos(int index, int colorIndex);
    int getColorCount(int index);
    QColor getPalette(int index, int paletteIndex);
    void updatePalette(int index);
    void setRescalePalette(bool on);
    bool getRescalePalette();
    void setPaletteScale(int index, double value);
    double getPaletteScale(int index);
    void setNormalize(bool on);
    bool getNormalize();
    void setMaxIterations(int index, int value);
    int getMaxIterations(int index);
    void setMaxAbsoluteValue(int index, double value);
    double getMaxAbsoluteValue(int index);
    void calcMax(int index);
    int getMax(int index);
    void setAntiAliasing(int value);
    int getAntiAliasing();
};
  
#endif
