#ifndef COLORDIALOG_H
#define COLORDIALOG_H

#include <QtGui/QWidget>
#include <QtGui/QHBoxLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QSlider>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QTabWidget>
#include "data.h"
#include "palette.h"

class ColorDialog : public QWidget
{
  Q_OBJECT

  private:
    Data *data;
    QTabWidget *colorTab;
    QSlider *scaleSlider[2];
    QPushButton *closeButton, *mandelDeleteColorButton, *juliaDeleteColorButton, *mandelEditColorButton, *juliaEditColorButton;
    Palette *palette[2];

  public:
    ColorDialog(Data *p_data, QWidget* parent=0, Qt::WindowFlags f=0);
    ~ColorDialog();

  signals:
    void mandelColorChanged();
    void juliaColorChanged(); 

  public slots: 
    void mandelEditColor();
    void juliaEditColor();
    void mandelDeleteColor();
    void juliaDeleteColor();
    void updateMandelColor();
    void updateJuliaColor();
    void updateMandelPalette();
    void updateJuliaPalette();
    void setPaletteScale(int value);
};

#endif
