#include <math.h>
#include <QtGui/QMainWindow>
#include <QtGui/QGroupBox>
#include <QtGui/QSplitter>
#include <QtGui/QScrollArea>
#include "data.h"
#include "colordialog.h"

ColorDialog::ColorDialog(Data *p_data, QWidget *parent, Qt::WindowFlags f) : QWidget(parent, f) {

  data = p_data;
  QVBoxLayout *mandelLayout = new QVBoxLayout;
  QWidget *mandelFrame = new QWidget;
  mandelFrame->setLayout(mandelLayout);
  QScrollArea *mandelScroll = new QScrollArea;
  palette[0] = new Palette(0, data);
  QObject::connect(palette[0], SIGNAL(paletteChanged()), this, SLOT(updateMandelColor()));
  mandelScroll->setWidget(palette[0]);  
  mandelLayout->addWidget(mandelScroll);
  mandelScroll->setMinimumHeight(palette[0]->height() + 20);
  QHBoxLayout *mandelButtonLayout = new QHBoxLayout;
  QWidget *mandelButtonFrame = new QWidget;
  mandelButtonFrame->setLayout(mandelButtonLayout);
  mandelEditColorButton = new QPushButton("Edit Color");
  QObject::connect(mandelEditColorButton, SIGNAL(clicked()), this, SLOT(mandelEditColor()));
  mandelButtonLayout->addWidget(new QWidget);
  mandelButtonLayout->addWidget(mandelEditColorButton); 
  mandelButtonLayout->addWidget(new QWidget);
  mandelDeleteColorButton = new QPushButton("Delete Color");
  QObject::connect(mandelDeleteColorButton, SIGNAL(clicked()), this, SLOT(mandelDeleteColor()));
  mandelButtonLayout->addWidget(mandelDeleteColorButton); 
  mandelButtonLayout->addWidget(new QWidget);
  QHBoxLayout *mandelScaleLayout = new QHBoxLayout;
  QWidget *mandelScaleFrame = new QWidget;
  mandelScaleFrame->setLayout(mandelScaleLayout);
  scaleSlider[0] = new QSlider(Qt::Horizontal);
  scaleSlider[0]->setMinimum(0);
  scaleSlider[0]->setMaximum(1000);
  scaleSlider[0]->setValue(114);
  scaleSlider[0]->setTickInterval(1);
  mandelScaleLayout->addWidget(new QLabel("Scale: "));
  mandelScaleLayout->addWidget(scaleSlider[0]);
  mandelLayout->addWidget(mandelScaleFrame);
  QObject::connect(scaleSlider[0], SIGNAL(valueChanged(int)), this, SLOT(setPaletteScale(int)));
  mandelLayout->addWidget(mandelButtonFrame);
  QVBoxLayout *juliaLayout = new QVBoxLayout;
  QWidget *juliaFrame = new QWidget;
  juliaFrame->setLayout(juliaLayout);
  QScrollArea *juliaScroll = new QScrollArea;
  palette[1] = new Palette(1, data);
  QObject::connect(palette[1], SIGNAL(paletteChanged()), this, SLOT(updateJuliaColor()));
  juliaScroll->setWidget(palette[1]);  
  juliaLayout->addWidget(juliaScroll);
  juliaScroll->setMinimumHeight(palette[1]->height() + 20);
  QHBoxLayout *juliaButtonLayout = new QHBoxLayout;
  QWidget *juliaButtonFrame = new QWidget;
  juliaButtonFrame->setLayout(juliaButtonLayout);
  juliaEditColorButton = new QPushButton("Edit Color");
  QObject::connect(juliaEditColorButton, SIGNAL(clicked()), this, SLOT(juliaEditColor()));
  juliaButtonLayout->addWidget(new QWidget);
  juliaButtonLayout->addWidget(juliaEditColorButton); 
  juliaButtonLayout->addWidget(new QWidget);
  juliaDeleteColorButton = new QPushButton("Delete Color");
  QObject::connect(juliaDeleteColorButton, SIGNAL(clicked()), this, SLOT(juliaDeleteColor()));
  juliaButtonLayout->addWidget(juliaDeleteColorButton); 
  juliaButtonLayout->addWidget(new QWidget);
  QHBoxLayout *juliaScaleLayout = new QHBoxLayout;
  QWidget *juliaScaleFrame = new QWidget;
  juliaScaleFrame->setLayout(juliaScaleLayout);
  scaleSlider[1] = new QSlider(Qt::Horizontal);
  scaleSlider[1]->setMinimum(0);
  scaleSlider[1]->setMaximum(1000);
  scaleSlider[1]->setValue(114);
  scaleSlider[1]->setTickInterval(1);
  juliaScaleLayout->addWidget(new QLabel("Scale: "));
  juliaScaleLayout->addWidget(scaleSlider[1]);
  juliaLayout->addWidget(juliaScaleFrame);
  QObject::connect(scaleSlider[1], SIGNAL(valueChanged(int)), this, SLOT(setPaletteScale(int)));
  juliaLayout->addWidget(juliaButtonFrame);
  QVBoxLayout *mainLayout = new QVBoxLayout;
  colorTab = new QTabWidget;
  colorTab->addTab(mandelFrame, "Mandelbrot Set");
  colorTab->addTab(juliaFrame, "   Julia Set    ");
  mainLayout->addWidget(colorTab);
  QHBoxLayout *buttonLayout = new QHBoxLayout;
  QWidget *buttonFrame = new QWidget;
  buttonFrame->setLayout(buttonLayout);
  closeButton = new QPushButton("Close");
  QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(hide()));
  buttonLayout->addWidget(new QWidget);
  buttonLayout->addWidget(closeButton);
  buttonLayout->addWidget(new QWidget);
  mainLayout->addWidget(buttonFrame);
  setLayout(mainLayout);
}

ColorDialog::~ColorDialog() {

}

void ColorDialog::mandelEditColor() {

  palette[0]->editColor();
}

void ColorDialog::juliaEditColor() {

  palette[1]->editColor();
}

void ColorDialog::mandelDeleteColor() {

  palette[0]->deleteColor();
}

void ColorDialog::juliaDeleteColor() {

  palette[1]->deleteColor();
}

void ColorDialog::updateMandelColor() {

  emit mandelColorChanged();
}

void ColorDialog::updateJuliaColor() {

  emit juliaColorChanged();
}

void ColorDialog::updateMandelPalette() {

  data->updatePalette(0);
  palette[0]->setMinimumWidth((int)((double)data->getMaxIterations(0)/data->getPaletteScale(0)) + 2 * MARGIN);
  palette[0]->setMaximumWidth((int)((double)data->getMaxIterations(0)/data->getPaletteScale(0)) + 2 * MARGIN);
  palette[0]->repaint();
}

void ColorDialog::updateJuliaPalette() {

  data->updatePalette(1);
  palette[1]->setMinimumWidth((int)((double)data->getMaxIterations(1)/data->getPaletteScale(1)) + 2 * MARGIN);
  palette[1]->setMaximumWidth((int)((double)data->getMaxIterations(1)/data->getPaletteScale(1)) + 2 * MARGIN);
  palette[1]->repaint();
}

void ColorDialog::setPaletteScale(int value) {

  int i;

  for (i = 0; i < 2; i++) {
    if (scaleSlider[i] == sender()) {
      data->setPaletteScale(i, pow(10.0, (double)value / 1000.0) - 0.8);
      palette[i]->setMinimumWidth((int)((double)data->getMaxIterations(i)/data->getPaletteScale(i)) + 2 * MARGIN);
      palette[i]->setMaximumWidth((int)((double)data->getMaxIterations(i)/data->getPaletteScale(i)) + 2 * MARGIN);
      palette[i]->repaint();
      break;
    }
  }
}
