#include <stdlib.h>
#include "wavrecorder.h"

WavRecorder::WavRecorder(Data *p_data, QThread *parent) : QThread(parent) {

  data = p_data;
}

void WavRecorder::run() {

  char header[44];
  double *buf[2];
  char *fileBuf;
  int i1, i2, i3, rate, byteRate, frame, frameCounter, size1, size2;

  file.setFileName(data->getSavePath());
  if (!file.open(QIODevice::WriteOnly))
    return;  
  header[0] = 0x52; header[1] = 0x49; header[2] = 0x46; header[3] = 0x46; // "RIFF"
  header[4] = 0x24; header[5] = 0x00; header[6] = 0xff; header[7] = 0x00; // ChunkSize
  header[8] = 0x57; header[9] = 0x41; header[10] = 0x56; header[11] = 0x45; // "WAVE"
  header[12] = 0x66; header[13] = 0x6d; header[14] = 0x74; header[15] = 0x20; // "fmt "
  header[16] = 0x10; header[17] = 0x00; header[18] = 0x00; header[19] = 0x00; // Subchunk1Size
  header[20] = 0x01; header[21] = 0x00; // AudioFormat
  header[22] = 0x02; header[23] = 0x00; // NumChannels
  rate = data->getRate();
  header[24] = (char)rate; // SampleRate
  header[25] = rate >> 8;
  header[26] = rate >> 16;  
  header[27] = rate >> 24; 
  byteRate = rate * 2 * 4; // Rate * Channels * Bytes per Sample
  header[28] = (char)byteRate; // ByteRate
  header[29] = byteRate >> 8;
  header[30] = byteRate >> 16;
  header[31] = byteRate >> 24;
  header[32] = 0x08; header[33] = 0x00; // BlockAlign = Channels * Bytes per Sample
  header[34] = 0x20; header[35] = 0x00; // BitsPerSample
  header[36] = 0x64; header[37] = 0x61; header[38] = 0x74; header[39] = 0x61; // "data"
  header[40] = 0x00; header[41] = 0x00; header[42] = 0xff; header[43] = 0x00; // Subchunk2Size
  file.write(header, 44);
  for (i1 = 0; i1 < 2; i1++) 
    buf[i1] = (double *)malloc(BLOCKSIZE * sizeof(double));
  fileBuf = (char *)malloc(8 * BLOCKSIZE);
  frameCounter = 0;
  data->initRec();
  while(data->getRecord()) {
    data->readBuf(buf, BLOCKSIZE);
    i3 = 0;
    for (i2 = 0; i2 < BLOCKSIZE; i2++) 
      for (i1 = 0; i1 < 2; i1++) {
        frame = (int)(1e9 * buf[i1][i2]);
        fileBuf[i3++] = (char)frame;    
        fileBuf[i3++] = frame >> 8;
        fileBuf[i3++] = frame >> 16;
        fileBuf[i3++] = frame >> 24;
      }                                  
    file.write(fileBuf, 8 * BLOCKSIZE);   
    frameCounter += BLOCKSIZE;
  }    
  size1 = 36 + 8 * frameCounter;
  header[0] = (char)size1;
  header[1] = size1 >> 8;
  header[2] = size1 >> 16;
  header[3] = size1 >> 24;
  file.seek(4);
  file.write(header, 4);
  size2 = 8 * frameCounter;
  header[0] = (char)size2;
  header[1] = size2 >> 8;
  header[2] = size2 >> 16;
  header[3] = size2 >> 24;
  file.seek(40);
  file.write(header, 4);  
  file.close();
}
