#include <QtCore/QString>
#include <QtCore/QMutexLocker>
#include <QtGui/QMessageBox>
#include <jack/jack.h>
#include <jack/midiport.h>
#include "data.h"
#include "jackprocessor.h"

JackProcessor::JackProcessor(Data *p_data, QObject *parent) : QObject(parent) {

  data = p_data;
}

void JackProcessor::initJack() {

  int i1;
  QString qs;
  
  if ((data->jackHandle = jack_client_open("QMiniRecorder", JackNullOption, NULL)) == 0) {
    QMessageBox::critical(0, "QMiniRecorder", "JACK server not running ?");
    exit(1);
  }
  for (i1 = 0; i1 < 2; i1++) {
    qs.sprintf("QMiniRecorder_in_%d", i1);
    data->jackIn[i1] = jack_port_register(data->jackHandle, qs.toLatin1(), JACK_DEFAULT_AUDIO_TYPE, JackPortIsInput, 0);
  }
  jack_set_process_callback(data->jackHandle, jack_static_callback, (void *)this);
  data->setJackBufSize(jack_get_buffer_size(data->jackHandle));
  data->setRate(jack_get_sample_rate(data->jackHandle));
  if (jack_activate(data->jackHandle)) {
    QMessageBox::critical(0, "QMiniRecorder", "Can't activate JACK.");
    exit(1);
  }  
}

int JackProcessor::jack_static_callback(jack_nframes_t nframes, void *arg)
{
  return ((JackProcessor *) arg)->jack_callback(nframes);
}

int JackProcessor::jack_callback(jack_nframes_t nframes)
{
  jack_default_audio_sample_t *jackBuf[2];
  int i;

  QMutexLocker jackMutexLocker(&data->jackMutex);
  if (!data->jackClosedFlag) {
    for (i = 0; i < 2; i++) 
      jackBuf[i] = (jack_default_audio_sample_t *)(jack_port_get_buffer(data->jackIn[i], nframes));
    if (nframes > 0) {
      data->writeBuf(jackBuf, nframes);
      emit chunkReady();
    }  
  } 
  return 0;
}
