#ifndef DATA_H
#define DATA_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QMutex>
#include <QtCore/QSemaphore>
#include <jack/jack.h>

#define BUFSIZE 262144
#define BLOCKSIZE 1024
#define WAVE_WIDTH 500
#define WAVE_HEIGHT 100
#define FRAME_RATE 25.0

class Data : public QObject
{
  private:
    QString savePath;
    double *buf[2];
    int bufSize, jackBufSize;
    int rate, readOfs, writeOfs;
    bool record;
    QSemaphore *recSemaphore;
    QMutex rwOfsMutex;
    
  public:
    double limits[4];
    jack_client_t *jackHandle;
    jack_port_t *jackIn[2];
    QMutex jackMutex;
    bool jackClosedFlag;
            
  public:
    Data(QObject* parent=0);
    ~Data();
    void setJackBufSize(int value);
    int getJackBufSize();
    void setRate(int value);
    int getRate();
    void stopJack();
    void initRec();
    void writeBuf(jack_default_audio_sample_t *src[], int nframes);
    void readBuf(double *dest[], int nframes);
    int getReadOfs();
    int getWriteOfs();
    void setRecord(bool on);
    bool getRecord();
    void setSavePath(QString qs);
    QString getSavePath();
};
  
#endif
