#include <stdlib.h>
#include "data.h"

Data::Data(QObject *parent) : QObject(parent) {

  int i;

  for (i = 0; i < 2; i++) {
    buf[i] = (double *)malloc(BUFSIZE * sizeof(double));
    memset(buf[i], 0, BUFSIZE * sizeof(double));
  }
  readOfs = 0;
  writeOfs = 0;
  rate = 44100;
  record = false;
  recSemaphore = new QSemaphore(BUFSIZE);
  recSemaphore->acquire(BLOCKSIZE);
  jackClosedFlag = false;
}

Data::~Data() {

  int i;

  for (i = 0; i < 2; i++)
    free(buf[i]);
}

void Data::setJackBufSize(int value) {
  
  jackBufSize = value;
}

int Data::getJackBufSize() {

  return(jackBufSize);
}

void Data::setRate(int value) {

  rate = value;
}
    
int Data::getRate() {

  return(rate);
}

void Data::stopJack() {

  int i;

  QMutexLocker jackMutexLocker(&jackMutex);
  for (i = 0; i < 2; i++) 
    jack_port_unregister (jackHandle, jackIn[i]);
  jack_client_close (jackHandle);  
  jackClosedFlag = true;
}

void Data::initRec() {

  QMutexLocker rwOfsMutexLocker(&rwOfsMutex);
  recSemaphore->acquire(recSemaphore->available());
  readOfs = writeOfs;
}

void Data::writeBuf(jack_default_audio_sample_t *src[], int nframes) {

  int i1, i2;

  for (i1 = 0; i1 < 4; i1++) 
    limits[i1] = 0;
  for (i1 = 0; i1 < 2; i1++) 
    for (i2 = 0; i2 < nframes; i2++) {
      buf[i1][(writeOfs + i2) % BUFSIZE] = src[i1][i2];
      if (src[i1][i2] < limits[2 * i1]) 
        limits[2 * i1] = src[i1][i2];
      else if (src[i1][i2] > limits[2 * i1 + 1]) 
        limits[2 * i1 + 1] = src[i1][i2];
    } 
  QMutexLocker rwOfsMutexLocker(&rwOfsMutex);
  writeOfs += nframes;
  if (writeOfs >= BUFSIZE) writeOfs -= BUFSIZE;
  recSemaphore->release(nframes);
}

void Data::readBuf(double *dest[], int nframes) {

  int i1, i2;

  recSemaphore->acquire(nframes);  
  for (i1 = 0; i1 < 2; i1++) 
    for (i2 = 0; i2 < nframes; i2++) 
      dest[i1][i2] = buf[i1][(readOfs + i2) % BUFSIZE];
  readOfs += nframes;
  if (readOfs >= BUFSIZE) readOfs -= BUFSIZE;
}

int Data::getReadOfs() {

  return(readOfs);
}

int Data::getWriteOfs() {

  return(writeOfs);
}

void Data::setRecord(bool on) {

  record = on;
}

bool Data::getRecord() {

  return(record);
}

void Data::setSavePath(QString qs) {

  savePath = qs;
}

QString Data::getSavePath() {

  return(savePath);
}
        